/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.xlsx.XlsxCell;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

class XlsxReader
implements FFFileReader<XlsxCell> {
    @NotNull
    private final Workbook workbook;
    @NotNull
    private final Iterator<Sheet> sheetIterator;
    @NotNull
    private final DataFormatter formatter;
    @Nullable
    private final FormulaEvaluator evaluator;
    private Sheet currentSheet;
    private Iterator<Row> rowIterator;

    public XlsxReader(@NotNull Workbook workbook, @NotNull DataFormatter formatter, @Nullable FormulaEvaluator evaluator) {
        this.workbook = workbook;
        this.sheetIterator = workbook.sheetIterator();
        this.formatter = formatter;
        this.evaluator = evaluator;
    }

    public boolean openNextTable() throws IOException {
        if (this.sheetIterator.hasNext()) {
            this.currentSheet = this.sheetIterator.next();
            this.rowIterator = this.currentSheet.rowIterator();
            return true;
        }
        return false;
    }

    @Nullable
    public String getCurrentTable() {
        return this.currentSheet.getSheetName();
    }

    @Nullable
    public XlsxCell[] readRow() throws IOException {
        while (this.rowIterator.hasNext()) {
            Row row = this.rowIterator.next();
            short lastCellNum = row.getLastCellNum();
            if (lastCellNum < 0) continue;
            XlsxCell[] cells = new XlsxCell[lastCellNum];
            int i = 0;
            while (i < cells.length) {
                cells[i] = new XlsxCell(row.getCell(i), this.formatter, this.evaluator);
                ++i;
            }
            return cells;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.evaluator != null) {
            this.evaluator.clearAllCachedResultValues();
        }
        this.workbook.close();
    }
}

