/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.FFOrderMappingStrategy;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.database.FFTableDefinition;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.exception.FFMappingException;
import com.dbeaver.jdbc.files.xlsx.XlsxTableProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.utils.Pair;

public class XlsxSheetMappingStrategy
implements FFStructureMappingStrategy<Object, XlsxTableProperties> {
    private static final FFOrderMappingStrategy<Object, XlsxTableProperties> ORDER_STRATEGY = new FFOrderMappingStrategy();

    @NotNull
    public List<Pair<String, FFTableDefinition<Object, XlsxTableProperties>>> map(@NotNull List<String> dataSourceNames, @NotNull List<FFTableDefinition<Object, XlsxTableProperties>> definitions) throws FFMappingException {
        return switch (this.chooseMergeStrategy(definitions)) {
            case MergeStrategy.BY_NAME -> this.mergeTablesByName(dataSourceNames, definitions);
            case MergeStrategy.BY_ORDER -> ORDER_STRATEGY.map(dataSourceNames, definitions);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private MergeStrategy chooseMergeStrategy(@NotNull List<FFTableDefinition<Object, XlsxTableProperties>> definitions) throws FFMappingException {
        List<String> tablesWithSheetMapping = definitions.stream().map(FFTableDefinition::tableStructure).map(FFTableStructure::properties).map(XlsxTableProperties::sheetName).filter(Objects::nonNull).toList();
        if (!tablesWithSheetMapping.isEmpty() && tablesWithSheetMapping.size() != definitions.size()) {
            throw new FFMappingException("All tables should have sheet names or none of them");
        }
        if (tablesWithSheetMapping.isEmpty()) {
            return MergeStrategy.BY_ORDER;
        }
        long distinctNames = tablesWithSheetMapping.stream().distinct().count();
        if (distinctNames != (long)tablesWithSheetMapping.size()) {
            throw new FFMappingException("Found tables with duplicate sheet names");
        }
        return MergeStrategy.BY_NAME;
    }

    @NotNull
    private List<Pair<String, FFTableDefinition<Object, XlsxTableProperties>>> mergeTablesByName(List<String> dataSourceNames, List<FFTableDefinition<Object, XlsxTableProperties>> definitions) {
        Map<String, FFTableDefinition> sheetToPair = definitions.stream().collect(Collectors.toMap(it -> ((XlsxTableProperties)it.tableStructure().properties()).sheetName(), it -> it));
        return dataSourceNames.stream().map(dataSourceName -> new Pair(dataSourceName, (Object)((FFTableDefinition)sheetToPair.get(dataSourceName)))).collect(Collectors.toList());
    }

    private static enum MergeStrategy {
        BY_NAME,
        BY_ORDER;

    }
}

