/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.utils.FFDataTypeUtils;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import com.dbeaver.jdbc.files.xml.XmlFileReaderFactory;
import com.dbeaver.jdbc.files.xml.XmlNode;
import com.dbeaver.jdbc.files.xml.XmlProperties;
import com.dbeaver.jdbc.files.xml.XmlReader;
import com.dbeaver.jdbc.files.xml.XmlTableProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;

public class XmlMetadataReader
implements FFDataFileMetadataReader<XmlNode, XmlTableProperties> {
    @NotNull
    private final XmlProperties properties;
    @NotNull
    private final XmlFileReaderFactory fileReaderFactory;

    public XmlMetadataReader(@NotNull XmlProperties properties, @NotNull XmlFileReaderFactory fileReaderFactory) {
        this.properties = properties;
        this.fileReaderFactory = fileReaderFactory;
    }

    @NotNull
    public List<String> getTableSourceNames(@NotNull Path dataPath) throws IOException {
        return List.of(FFIOUtils.truncateFileExtension((Path)dataPath));
    }

    @NotNull
    public FFTableStructure<XmlNode, XmlTableProperties> getTableStructure(@NotNull FFSchemaName schemaName, @NotNull Path dataPath, @NotNull String tableSourceName) throws IOException {
        new ArrayList();
        Throwable throwable = null;
        Object var5_6 = null;
        try (XmlReader reader = this.fileReaderFactory.createReader(dataPath, this.properties);){
            if (reader.openNextTable()) {
                FFTableName tableName = new FFTableName(schemaName, FFIOUtils.truncateFileExtension((Path)dataPath));
                return new FFTableStructure(this.extractColumns(tableName, reader), (FFTableProperties)XmlTableProperties.EMPTY);
            }
            throw new IOException("No tables found in XML file");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    private List<ColumnInfo<XmlNode>> extractColumns(@NotNull FFTableName tableName, @NotNull FFFileReader<XmlNode> reader) throws IOException {
        XmlNode[] firstRow = (XmlNode[])reader.readRow();
        if (firstRow == null) {
            return List.of();
        }
        ArrayList<XmlNode[]> sampleRows = new ArrayList<XmlNode[]>(this.properties.sampleRows());
        sampleRows.add(firstRow);
        int i = 1;
        while (i < this.properties.sampleRows()) {
            XmlNode[] nodes = (XmlNode[])reader.readRow();
            if (nodes == null) break;
            sampleRows.add(nodes);
            ++i;
        }
        LinkedHashMap<String, SQLType> columnTypes = new LinkedHashMap<String, SQLType>();
        Iterator iterator = sampleRows.iterator();
        while (iterator.hasNext()) {
            XmlNode[] sampleRow;
            XmlNode[] xmlNodeArray = sampleRow = (XmlNode[])iterator.next();
            int n = sampleRow.length;
            int n2 = 0;
            while (n2 < n) {
                XmlNode node = xmlNodeArray[n2];
                SQLType type = FFDataTypeUtils.determineDataType((String)node.value());
                columnTypes.compute(node.name(), (key, value) -> {
                    if (value == null) {
                        return type;
                    }
                    return FFDataTypeUtils.determineCommonDataType((SQLType)value, (SQLType)type);
                });
                ++n2;
            }
        }
        return columnTypes.entrySet().stream().map(entry -> new ColumnInfo(tableName.schema().name(), tableName.name(), (String)entry.getKey(), (String)entry.getKey(), (SQLType)entry.getValue(), XmlNode::value)).toList();
    }
}

