/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.MultipartTableReader;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.xml.XmlFileReaderFactory;
import com.dbeaver.jdbc.files.xml.XmlNode;
import com.dbeaver.jdbc.files.xml.XmlProperties;
import com.dbeaver.jdbc.files.xml.XmlTableProperties;
import com.dbeaver.jdbc.files.xml.XmlTableReader;
import java.io.IOException;
import java.util.List;
import org.jkiss.code.NotNull;

public class XmlTableReaderFactory
implements FFTableReaderFactory<XmlNode, XmlTableProperties> {
    @NotNull
    private final XmlFileReaderFactory jsonFileReaderFactory;
    @NotNull
    private final XmlProperties properties;

    public XmlTableReaderFactory(@NotNull XmlFileReaderFactory jsonFileReaderFactory, @NotNull XmlProperties properties) {
        this.jsonFileReaderFactory = jsonFileReaderFactory;
        this.properties = properties;
    }

    @NotNull
    public FFTableReader<XmlNode> createReader(@NotNull FFTable<XmlNode, XmlTableProperties> table) throws IOException {
        MultipartTableReader multipartTableReader = new MultipartTableReader(table, (FFFileReaderFactory)this.jsonFileReaderFactory, (FFProperties)this.properties, false);
        List columns = table.structure().columns();
        return new XmlTableReader(columns, (FFTableReader<XmlNode>)multipartTableReader);
    }
}

