/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge.util;

import com.dbeaver.jdbc.odbc.OdbcException;
import com.dbeaver.jdbc.odbc.OdbcFeatureNotSupportedException;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.OdbcResource;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class OdbcUtil {
    public static final String STATE_FEATURE_NOT_SUPPORTED = "IM001";
    public static final String STATE_FEATURE_NOT_IMPLEMENTED = "HYC00";
    private static final boolean TRACING_ENABLED = Boolean.getBoolean("dbeaver.odbc.tracing.enabled");

    @NotNull
    public static SQLFeatureNotSupportedException notImplemented() {
        return new OdbcFeatureNotSupportedException("Method " + String.valueOf(Thread.currentThread().getStackTrace()[2]) + " not implemented");
    }

    @NotNull
    public static SQLFeatureNotSupportedException notSupported() {
        return OdbcUtil.notSupportedInternal("no corresponding ODBC API");
    }

    @NotNull
    public static SQLFeatureNotSupportedException notSupported(@NotNull String reason) {
        return OdbcUtil.notSupportedInternal(reason);
    }

    @NotNull
    private static SQLFeatureNotSupportedException notSupportedInternal(@NotNull String reason) {
        return new OdbcFeatureNotSupportedException("Method " + String.valueOf(Thread.currentThread().getStackTrace()[3]) + " not implemented: " + reason);
    }

    public static boolean isTracingEnabled() {
        return TRACING_ENABLED;
    }

    public static void check(@NotNull OdbcResource<?> resource, int rc) throws SQLException {
        if (rc == 1) {
            resource.addWarning();
        }
        OdbcUtil.check(rc, resource.getHandle());
    }

    public static void check(int rc, @NotNull OdbcHandle handle) throws SQLException {
        if (OdbcUtil.succeeded(rc)) {
            return;
        }
        SQLException exception = OdbcUtil.diagnose(handle);
        if (exception != null) {
            throw exception;
        }
        switch (rc) {
            case -2: {
                throw new OdbcException("Invalid handle: " + String.valueOf((Object)handle.getType()), null, 0);
            }
            case 99: {
                throw new OdbcException("Need data", null, 0);
            }
            case 100: {
                throw new OdbcException("No data", null, 0);
            }
        }
        throw new OdbcException("Unknown error", null, 0);
    }

    @Nullable
    public static SQLException diagnose(@NotNull OdbcHandle handle) {
        if (handle.isClosed()) {
            return null;
        }
        ShortByReference messageLength = new ShortByReference();
        IntByReference nativeError = new IntByReference();
        Memory message = new Memory(512L * (long)Native.WCHAR_SIZE + 1L);
        Memory state = new Memory(5L * (long)Native.WCHAR_SIZE + 1L);
        SQLException root = null;
        short index = 1;
        while (index <= 1) {
            if (!OdbcUtil.succeeded(OdbcLibrary.INSTANCE.SQLGetDiagRecW(handle.getType(), handle, index, (Pointer)state, nativeError, (Pointer)message, (short)512, messageLength))) break;
            if (messageLength.getValue() != 0) {
                String reason = message.getWideString(0L);
                String stateString = state.getWideString(0L);
                SQLException exception = STATE_FEATURE_NOT_SUPPORTED.equals(stateString) || STATE_FEATURE_NOT_IMPLEMENTED.equals(stateString) ? new OdbcFeatureNotSupportedException(reason, stateString, nativeError.getValue()) : new OdbcException(reason, stateString, nativeError.getValue());
                if (root == null) {
                    root = exception;
                } else {
                    root.setNextException(exception);
                }
            }
            index = (short)(index + 1);
        }
        return root;
    }

    public static boolean succeeded(int rc) {
        return rc == 0 || rc == 1;
    }
}

