/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.dbeaver.jdbc.salesforce.meta.ObjectArrayFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.dbeaver.jdbc.salesforce.meta.SFArray;
import com.dbeaver.jdbc.salesforce.meta.SFStruct;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeGlobalSObjectResult;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.IField;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.ws.bind.XmlObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class SalesForceUtils {
    public static int getFieldDataType(@Nullable FieldType field) {
        if (field == null) {
            return 12;
        }
        switch (field) {
            case id: {
                return -8;
            }
            case _boolean: {
                return 16;
            }
            case date: {
                return 91;
            }
            case datetime: {
                return 93;
            }
            case time: {
                return 92;
            }
            case string: 
            case textarea: 
            case phone: 
            case url: 
            case email: 
            case location: 
            case address: 
            case json: {
                return 12;
            }
            case _int: {
                return 4;
            }
            case _long: {
                return -5;
            }
            case _double: {
                return 8;
            }
            case currency: {
                return 2;
            }
            case reference: {
                return 12;
            }
            case picklist: {
                return 12;
            }
            case multipicklist: {
                return 2003;
            }
            case complexvalue: {
                return 2002;
            }
            case anyType: {
                return 2003;
            }
        }
        return 12;
    }

    public static boolean isSystemField(ISObject object, String fieldName) {
        return fieldName.equals("type") || fieldName.equals("Id") && object.getSObjectField(fieldName) == null;
    }

    public static Object makeJdbcValue(ISObject object, Object value) {
        if (value instanceof ISObject) {
            return new SFStruct(object, (ISObject)value);
        }
        return value;
    }

    public static IField findField(IDescribeSObjectResult tableInfo, String fieldName) {
        IField[] iFieldArray = tableInfo.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            if (f.getName().equals(fieldName)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static Object readFieldValue(@NotNull SalesForceConnection connection, @NotNull ISObject object, @NotNull ObjectElementInfo field, @NotNull String path) {
        XmlObject current;
        if (!(object instanceof XmlObject)) {
            return object.getSObjectField(field.getName());
        }
        XmlObject xmlObject = (XmlObject)object;
        String[] stringArray = path.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (current == null) {
                return null;
            }
            current = current.getChild(segment);
            ++n2;
        }
        if (field instanceof ObjectArrayFieldInfo) {
            ObjectArrayFieldInfo arrayFieldInfo = (ObjectArrayFieldInfo)field;
            return new SFArray(arrayFieldInfo.getObject(), current);
        }
        return current != null ? current.getValue() : null;
    }

    public static String getTableType(IDescribeGlobalSObjectResult object) {
        if (object.isIsInterface() || object.isHasSubtypes()) {
            return "ABSTRACT_TABLE";
        }
        return "TABLE";
    }

    public static boolean isShowFlatStructures(SalesForceConnection connection) {
        return false;
    }
}

