/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceVisitor;
import com.dbeaver.jdbc.files.FFFileScanner;
import com.dbeaver.jdbc.files.FFResult;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.EnumSet;
import java.util.List;
import org.jkiss.code.NotNull;

public class FFDataSourceScannerImpl<T, TP extends FFTableProperties, P extends FFProperties>
implements FFDataSourceScanner<T, TP, P> {
    @NotNull
    private final FFFileScanner<T, TP> fileScanner;

    public FFDataSourceScannerImpl(@NotNull FFFileScanner<T, TP> fileScanner) {
        this.fileScanner = fileScanner;
    }

    @Override
    @NotNull
    public FFResult<List<FFTable<T, TP>>, Exception> scan(@NotNull FFDataSource<P> dataSource) {
        int maxDepth = ((FFProperties)dataSource.properties()).scanSubfolders() ? Integer.MAX_VALUE : 1;
        try {
            return this.scan0(dataSource, maxDepth);
        }
        catch (IOException e) {
            return new FFResult<List<FFTable<T, TP>>, Exception>(List.of(), List.of(e));
        }
    }

    private FFResult<List<FFTable<T, TP>>, Exception> scan0(@NotNull FFDataSource<P> dataSource, int maxDepth) throws IOException {
        Path start = dataSource.path();
        PathMatcher pathMatcher = Files.isRegularFile(start, new LinkOption[0]) ? FFIOUtils.getAllFilesPathMatcher(start.getFileSystem()) : FFIOUtils.getPathMatcher(dataSource);
        FFDataSourceVisitor visitor = new FFDataSourceVisitor(file -> {
            if (pathMatcher.matches(FFIOUtils.relativePathOrFileName(start, file))) {
                return this.fileScanner.scan(dataSource, (Path)file);
            }
            return List.of();
        });
        Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        return visitor.result();
    }
}

