/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.files.FFResult;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.utils.function.ThrowableFunction;

public class FFDataSourceVisitor<T, TP extends FFTableProperties>
extends SimpleFileVisitor<Path> {
    private static final Logger log = Logger.getLogger(FFDataSourceVisitor.class.getName());
    private final List<FFTable<T, TP>> tables = new ArrayList<FFTable<T, TP>>();
    private final List<Exception> errors = new ArrayList<Exception>();
    private final ThrowableFunction<Path, List<FFTable<T, TP>>, IOException> visitor;

    public FFDataSourceVisitor(ThrowableFunction<Path, List<FFTable<T, TP>>, IOException> visitor) {
        this.visitor = visitor;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        try {
            this.tables.addAll((Collection)this.visitor.apply((Object)file));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to visit file " + String.valueOf(file) + ": " + e.getMessage(), e);
            this.errors.add(e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        log.log(Level.WARNING, "Failed to visit file " + String.valueOf(file) + ": " + exc.getMessage(), exc);
        this.errors.add(exc);
        return FileVisitResult.CONTINUE;
    }

    public FFResult<List<FFTable<T, TP>>, Exception> result() {
        return new FFResult<List<FFTable<T, TP>>, Exception>(this.tables, this.errors);
    }
}

