/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.engine.FFQueryAnalysisResult;
import com.dbeaver.jdbc.files.engine.FFQueryAnalyzer;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public abstract class FFStatement
extends AbstractJdbcStatement<FFConnection> {
    private static final Object NULL = new Object();
    protected final AtomicBoolean canceled = new AtomicBoolean(false);
    private final Map<Integer, Object> indexedParams = new HashMap<Integer, Object>();
    private volatile boolean closed = false;
    protected final AtomicReference<ResultSet> resultSet = new AtomicReference();

    public FFStatement(@NotNull FFConnection connection) throws SQLException {
        super((AbstractJdbcConnection)connection);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureOpen();
        throw new SQLFeatureNotSupportedException("Escape processing is not supported");
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.ensureOpen();
        throw new SQLFeatureNotSupportedException("Query timeout is not supported");
    }

    protected boolean execute(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        if (sql.isBlank()) {
            throw new SQLException("SQL query is empty");
        }
        if (columnIndexes != null && columnIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Column indexes are not supported");
        }
        if (columnNames != null && columnNames.length > 0) {
            throw new SQLFeatureNotSupportedException("Column names are not supported");
        }
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported");
        }
        String query = sql;
        int i = 0;
        while (i < this.indexedParams.size()) {
            int paramIndex = i + 1;
            if (!this.indexedParams.containsKey(paramIndex)) {
                throw new SQLException("Parameter " + paramIndex + " is not bind");
            }
            Object value = this.indexedParams.get(paramIndex);
            Object strValue = value instanceof String || value instanceof java.util.Date ? "'" + String.valueOf(value) + "'" : (value == NULL ? "NULL" : value.toString());
            query = query.replaceFirst("\\?", (String)strValue);
            ++i;
        }
        FFQueryAnalyzer analyzer = new FFQueryAnalyzer(((FFConnection)this.connection).getSchema());
        this.execute(columnIndexes, columnNames, autoGeneratedKeys, analyzer.analyze(query));
        return true;
    }

    public ResultSet execute(@Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys, FFQueryAnalysisResult analysisResult) throws SQLException {
        try {
            ResultSet result = this.execute0(columnIndexes, columnNames, autoGeneratedKeys, analysisResult);
            ResultSet old = this.resultSet.getAndSet(result);
            if (old != null) {
                old.close();
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (Exception e) {
            throw FFExceptionUtils.wrapException(e);
        }
        finally {
            this.canceled.set(false);
        }
    }

    protected abstract ResultSet execute0(@Nullable int[] var1, @Nullable String[] var2, int var3, FFQueryAnalysisResult var4) throws SQLException;

    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, null, null, 2);
        return this.getResultSet();
    }

    public void setCursorName(String name) throws SQLException {
        this.ensureOpen();
        throw new SQLFeatureNotSupportedException("Cursor is not supported");
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Fetch direction is not supported");
        }
    }

    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 2;
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.indexedParams.put(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, NULL, sqlType, 0);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x, 16);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x, -6);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x, 5);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x, 4);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x, -5);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x), 6);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x, 8);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x, 2);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x, 12);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, x, 91);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, x, 92);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, x, 93);
    }

    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), 0);
    }

    public void clearParameters() throws SQLException {
        this.indexedParams.clear();
    }

    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Update is not supported");
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        ResultSet resultSet = this.resultSet.getAndSet(null);
        if (resultSet != null) {
            resultSet.close();
        }
        this.onClose();
        ((FFConnection)this.connection).removeStatement((Statement)((Object)this));
    }

    protected abstract void onClose() throws SQLException;

    public void cancel() throws SQLException {
        this.ensureOpen();
        if (this.isCanceled()) {
            return;
        }
        this.canceled.set(true);
        this.onCancel();
    }

    private boolean isCanceled() throws SQLException {
        this.ensureOpen();
        return this.canceled.get();
    }

    protected abstract void onCancel() throws SQLException;

    public ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.resultSet.get();
    }

    public int getUpdateCount() throws SQLException {
        this.ensureOpen();
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        ResultSet result = this.resultSet.getAndSet(null);
        if (result != null) {
            result.close();
        }
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpen();
        switch (current) {
            case 1: {
                return this.getMoreResults();
            }
            case 2: 
            case 3: {
                throw new SQLException("Multiple open results are not supported");
            }
        }
        throw new SQLException("Invalid argument: " + current);
    }

    public boolean isClosed() throws SQLException {
        return ((FFConnection)this.connection).isClosed() || this.closed;
    }

    protected void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
    }
}

