/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.database.FFSchema;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FFDatabase {
    private final SortedMap<FFSchemaName, FFSchema> dbTree;

    public FFDatabase(SortedMap<FFSchemaName, FFSchema> dbTree) {
        this.dbTree = dbTree;
    }

    @NotNull
    public List<FFSchemaName> schemas() {
        return new ArrayList<FFSchemaName>(this.dbTree.keySet());
    }

    @NotNull
    public List<FFSchemaName> schemas(@Nullable String catalog, @NotNull Pattern schemaPattern) throws SQLException {
        if (catalog != null && !catalog.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Catalogs are not supported");
        }
        return this.schemas().stream().filter(q -> schemaPattern.matcher(q.name()).matches()).toList();
    }

    @NotNull
    public Set<FFTableName> tables(@NotNull FFSchemaName schemaName) {
        FFSchema schema = (FFSchema)this.dbTree.get(schemaName);
        if (schema == null) {
            return Set.of();
        }
        return schema.tables();
    }

    @NotNull
    public List<FFTable<?, ?>> tables(@Nullable String catalog, @NotNull Pattern schemaPattern, @NotNull Pattern tableNamePattern) throws SQLException {
        ArrayList list = new ArrayList();
        for (FFSchemaName it : this.schemas(catalog, schemaPattern)) {
            for (FFTableName t : this.tables(it)) {
                if (!tableNamePattern.matcher(t.name()).matches()) continue;
                FFTable<?, ?> table = this.table(t);
                list.add(table);
            }
        }
        return list;
    }

    @NotNull
    public FFTable<?, ?> table(@NotNull FFTableName tableName) throws SQLException {
        return Optional.ofNullable((FFSchema)this.dbTree.get(tableName.schema())).map(s -> s.table(tableName)).orElseThrow(() -> new SQLException("Table not found: " + String.valueOf(tableName)));
    }

    @NotNull
    public List<ColumnInfo<?>> columns(@Nullable String catalog, @NotNull Pattern schemaPattern, @NotNull Pattern tablePattern, @NotNull Pattern columnPattern) throws SQLException {
        ArrayList result = new ArrayList();
        try {
            for (FFTable<?, ?> table : this.tables(catalog, schemaPattern, tablePattern)) {
                FFTableStructure<?, ?> structure = table.structure();
                for (ColumnInfo<?> column : structure.columns()) {
                    if (!columnPattern.matcher(column.columnName()).matches()) continue;
                    result.add(column);
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result;
    }
}

