/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public abstract class FFRealTablesNamesFinder
extends TablesNamesFinder<Void> {
    private final Set<String> cteNames = new HashSet<String>();
    private final Set<String> tableAliases = new HashSet<String>();
    private final Set<Table> visitedTables = Collections.newSetFromMap(new IdentityHashMap());

    public Void visit(@NotNull WithItem withItem, @Nullable Object context) {
        if (withItem.getAlias() != null) {
            this.cteNames.add(withItem.getAlias().getName());
        }
        withItem.getSelect().accept((SelectVisitor)this, context);
        return null;
    }

    public Void visit(@NotNull PlainSelect plainSelect, @Nullable Object context) {
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (plainSelect.getSelectItems() != null) {
            for (SelectItem item : plainSelect.getSelectItems()) {
                item.accept((SelectItemVisitor)this, null);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.getHaving().accept((ExpressionVisitor)this);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept((ExpressionVisitor)this);
        }
        return null;
    }

    public Void visit(@NotNull Table table, @Nullable Object context) {
        if (this.visitedTables.contains(table)) {
            return null;
        }
        if (this.cteNames.contains(table.getName())) {
            return null;
        }
        if (this.tableAliases.contains(table.getName())) {
            return null;
        }
        if (table.getAlias() != null) {
            this.tableAliases.add(table.getAlias().getName());
        }
        this.visit(table);
        this.visitedTables.add(table);
        return null;
    }

    public abstract void visit(@NotNull Table var1);
}

