/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine;

import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.engine.FFRealTablesNamesFinder;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import org.jkiss.code.NotNull;

public class FFTablesNamesCollector
extends FFRealTablesNamesFinder {
    @NotNull
    private final String defaultSchemaName;
    private final Set<FFTableName> tableNames = new HashSet<FFTableName>();

    private FFTablesNamesCollector(@NotNull String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    @NotNull
    static Set<FFTableName> collectTableNames(@NotNull String defaultSchema, @NotNull Statement statement) {
        FFTablesNamesCollector collector = new FFTablesNamesCollector(defaultSchema);
        collector.init(true);
        statement.accept((StatementVisitor)collector);
        return collector.tableQualifiers();
    }

    @NotNull
    Set<FFTableName> tableQualifiers() {
        return Collections.unmodifiableSet(this.tableNames);
    }

    @Override
    public void visit(@NotNull Table table) {
        List nameParts = table.getNameParts();
        if (nameParts.size() > 2) {
            throw new IllegalArgumentException("Table name must not contain more than two parts: " + table.getName());
        }
        String schema = nameParts.size() > 1 ? FFDriverUtils.unquote((String)nameParts.get(1)) : this.defaultSchemaName;
        String name = FFDriverUtils.unquote((String)nameParts.get(0));
        this.tableNames.add(new FFTableName(new FFSchemaName(schema), name));
    }
}

