/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.file;

import com.dbeaver.jdbc.files.FFStatementFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.engine.file.FilePreparedStatement;
import com.dbeaver.jdbc.files.engine.file.FileStatement;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.jkiss.code.NotNull;

public class FileStatementFactory
implements FFStatementFactory {
    @NotNull
    public FileStatement createStatement(@NotNull FFConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Only TYPE_FORWARD_ONLY result set type is supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Only CONCUR_READ_ONLY result set concurrency is supported");
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException("Only CLOSE_CURSORS_AT_COMMIT result set holdability is supported");
        }
        return new FileStatement(connection);
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@NotNull FFConnection connection, @NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Only TYPE_FORWARD_ONLY result set type is supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Only CONCUR_READ_ONLY result set concurrency is supported");
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException("Only CLOSE_CURSORS_AT_COMMIT result set holdability is supported");
        }
        return new FilePreparedStatement(connection, sql);
    }

    @Override
    @NotNull
    public CallableStatement prepareCall(@NotNull FFConnection connection, @NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Callable statements are not supported");
    }
}

