/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.utils;

import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFProperties;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public final class FFIOUtils {
    private static final Logger log = Logger.getLogger(FFIOUtils.class.getName());

    private FFIOUtils() {
    }

    @NotNull
    public static String truncateFileExtension(@NotNull Path path) {
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    @NotNull
    public static String getFileExtension(Path file) {
        String fileName = file.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return fileName.substring(dotIndex + 1);
    }

    @NotNull
    public static Path deleteDirectoryContents(final @NotNull Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path must be a directory");
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(path)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                log.log(Level.WARNING, "Error deleting file: " + String.valueOf(file), exc);
                return FileVisitResult.CONTINUE;
            }
        });
        return path;
    }

    public static String wildcardForExtensions(Set<String> fileExtensions) {
        if (fileExtensions.isEmpty()) {
            return "*";
        }
        String sortedExtensions = fileExtensions.stream().sorted().collect(Collectors.joining(","));
        return "**.{" + sortedExtensions + "}";
    }

    @NotNull
    public static PathMatcher getPathMatcher(@NotNull FFDataSource<?> dataSource) {
        return FFIOUtils.getFileSystemPathMatcherOrDefault(dataSource.path().getFileSystem(), ((FFProperties)dataSource.properties()).wildcard());
    }

    @NotNull
    public static PathMatcher getAllFilesPathMatcher(@NotNull FileSystem fileSystem) {
        return FFIOUtils.getFileSystemPathMatcherOrDefault(fileSystem, "**");
    }

    @NotNull
    private static PathMatcher getFileSystemPathMatcherOrDefault(FileSystem fileSystem, String globPattern) {
        String syntaxAndPattern = "glob:" + globPattern;
        try {
            return fileSystem.getPathMatcher(syntaxAndPattern);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
        }
    }

    @NotNull
    public static Path relativePathOrFileName(@NotNull Path start, @NotNull Path path) {
        Path relative = start.relativize(path);
        if (relative.toString().isEmpty()) {
            return path.getFileName();
        }
        return relative;
    }

    @NotNull
    public static String concat(@Nullable Path path, @NotNull String delimiter) {
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        if (path != null) {
            path.forEach(it -> {
                Path name = it.getFileName();
                if (name != null) {
                    stringJoiner.add(name.toString());
                }
            });
        }
        return stringJoiner.toString();
    }
}

