/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class UPDArray
implements Array {
    private final String baseTypeName;
    private final int baseType;
    private final Object[] values;

    public UPDArray(String baseTypeName, int baseType, Object[] values) {
        this.baseTypeName = baseTypeName;
        this.baseType = baseType;
        this.values = values;
    }

    public static UPDArray from(Array array) throws SQLException {
        Object values = array.getArray();
        if (values instanceof Object[]) {
            return new UPDArray(array.getBaseTypeName(), array.getBaseType(), (Object[])values);
        }
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = array.getResultSet();){
            while (resultSet.next()) {
                Object object = resultSet.getObject(2);
                result.add(object != null ? object.toString() : null);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new UPDArray(array.getBaseTypeName(), array.getBaseType(), result.toArray(new String[0]));
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.values;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index < 1L || index > (long)this.values.length) {
            throw new SQLException("Index out of bounds: " + index);
        }
        if (count < 0) {
            throw new SQLException("Count cannot be negative: " + count);
        }
        int fromIndex = (int)index - 1;
        int toIndex = Math.min(fromIndex + count, this.values.length);
        return Arrays.copyOfRange(this.values, fromIndex, toIndex);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void free() throws SQLException {
    }
}

