/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class UPDClob
implements Clob,
NClob {
    private String data;

    public UPDClob(String data) {
        this.data = data;
    }

    @Override
    public long length() throws SQLException {
        return this.data.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || pos > (long)this.data.length()) {
            throw new SQLException("Position out of bounds");
        }
        return this.data.substring((int)pos - 1, (int)pos - 1 + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.data);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.data.getBytes());
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start < 1L || start > (long)this.data.length()) {
            throw new SQLException("Position out of bounds");
        }
        return this.data.indexOf(searchstr, (int)start - 1) + 1;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (start < 1L || start > (long)this.data.length()) {
            throw new SQLException("Position out of bounds");
        }
        String searchString = searchstr.getSubString(1L, (int)searchstr.length());
        return this.data.indexOf(searchString, (int)start - 1) + 1;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos < 1L || pos > (long)this.data.length()) {
            throw new SQLException("Position out of bounds");
        }
        if (offset < 0 || len < 0 || offset + len > str.length()) {
            throw new SQLException("Offset or length out of bounds");
        }
        String newData = this.data.substring(0, (int)pos - 1) + str.substring(offset, offset + len) + this.data.substring((int)pos - 1 + len);
        this.data = newData;
        return len;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L || len > (long)this.data.length()) {
            throw new SQLException("Length out of bounds");
        }
        this.data = this.data.substring(0, (int)len);
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > (long)this.data.length()) {
            throw new SQLException("Position out of bounds");
        }
        return new StringReader(this.data.substring((int)pos - 1, (int)pos - 1 + (int)length));
    }
}

