/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import com.dbeaver.jdbc.upd.protocol.UPDArray;
import com.dbeaver.jdbc.upd.protocol.UPDArrayAdapter;
import com.dbeaver.jdbc.upd.protocol.UPDStruct;
import com.dbeaver.jdbc.upd.protocol.UPDStructAdapter;
import com.dbeaver.jdbc.upd.protocol.UPDValueReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.Base64;
import org.jkiss.utils.rest.RpcConstants;
import org.jkiss.utils.rpc.RpcConstants;

public final class UPDUtils {
    public static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(LocalDate.class, (Object)new RpcConstants.LocalDateAdapter()).registerTypeAdapter(LocalDateTime.class, (Object)new RpcConstants.LocalDateTimeAdapter()).registerTypeAdapter(UPDArray.class, (Object)new UPDArrayAdapter()).registerTypeAdapter(UPDStruct.class, (Object)new UPDStructAdapter()).disableHtmlEscaping().create();
    public static final Type MAP_TYPE_TOKEN = new TypeToken<Map<String, Object>>(){}.getType();

    private UPDUtils() {
    }

    public static String getUniqueMethodName(Method method) {
        String paramTypes = Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(","));
        return method.getName() + "(" + paramTypes + ")";
    }

    @Nullable
    public static String toStringPresentation(@Nullable Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return RpcConstants.ISO_DATE_FORMAT.format((Date)value);
        }
        if (value instanceof Time) {
            return RpcConstants.ISO_TIME_FORMAT.format((Time)value);
        }
        if (value instanceof Timestamp) {
            return RpcConstants.ISO_TIMESTAMP_FORMAT.format((Timestamp)value);
        }
        if (value instanceof Array) {
            return GSON.toJson((Object)UPDArray.from((Array)value));
        }
        if (value instanceof byte[]) {
            return Base64.encode((byte[])((byte[])value));
        }
        if (value instanceof Blob) {
            return Base64.encode((byte[])((Blob)value).getBytes(1L, (int)((Blob)value).length()));
        }
        if (value instanceof Clob) {
            return ((Clob)value).getSubString(1L, (int)((Clob)value).length());
        }
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getString();
        }
        if (value instanceof Struct) {
            return GSON.toJson((Object)UPDStruct.from((Struct)value));
        }
        if (value instanceof UPDValueReader) {
            return ((UPDValueReader)value).readString();
        }
        return value.toString();
    }

    public static int inferType(@Nullable Object param) {
        if (param == null) {
            return 0;
        }
        Class<?> valueClass = param.getClass();
        if (valueClass == Boolean.class) {
            return 16;
        }
        if (valueClass == Byte.class) {
            return -6;
        }
        if (valueClass == Short.class) {
            return 5;
        }
        if (valueClass == Integer.class) {
            return 4;
        }
        if (valueClass == Long.class) {
            return -5;
        }
        if (valueClass == Float.class) {
            return 6;
        }
        if (valueClass == Double.class) {
            return 8;
        }
        if (valueClass == String.class) {
            return 12;
        }
        if (valueClass == Date.class) {
            return 91;
        }
        if (valueClass == Time.class) {
            return 92;
        }
        if (valueClass == Timestamp.class) {
            return 93;
        }
        if (Array.class.isAssignableFrom(valueClass)) {
            return 2003;
        }
        if (Struct.class.isAssignableFrom(valueClass)) {
            return 2002;
        }
        if (SQLXML.class.isAssignableFrom(valueClass)) {
            return 2009;
        }
        if (Blob.class.isAssignableFrom(valueClass)) {
            return 2004;
        }
        if (Clob.class.isAssignableFrom(valueClass)) {
            return 2005;
        }
        if (valueClass == UPDValueReader.class) {
            return 1111;
        }
        if (valueClass == UPDArray.class) {
            return 2003;
        }
        if (valueClass == UPDStruct.class) {
            return 2002;
        }
        return 1111;
    }

    public static Map<String, Object> saveToMap(@NotNull Object object) {
        JsonElement jsonTree = GSON.toJsonTree(object, object.getClass());
        return (Map)GSON.fromJson(jsonTree, MAP_TYPE_TOKEN);
    }

    public static <T> T loadFromMap(@NotNull Class<T> theClass, @NotNull Map<String, Object> map) {
        String jsonText = GSON.toJson(map);
        return (T)GSON.fromJson(jsonText, theClass);
    }
}

