/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public final class RAGUtils {
    private RAGUtils() {
    }

    @NotNull
    public static List<DBSEntity> flattenContainers(@NotNull DBRProgressMonitor monitor, @NotNull Collection<DBSObject> objects) throws DBException {
        ArrayList<DBSEntity> scopeObjects = new ArrayList<DBSEntity>();
        for (DBSObject dbsObject : objects) {
            for (DBSObject object : RAGUtils.flattenContainer(monitor, dbsObject)) {
                if (!(object instanceof DBSEntity)) continue;
                DBSEntity dbsEntity = (DBSEntity)object;
                scopeObjects.add(dbsEntity);
            }
        }
        return scopeObjects;
    }

    @NotNull
    public static List<DBSObject> flattenContainer(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        if (AIUtils.isExcludableObject((DBRProgressMonitor)monitor, (DBSObject)object)) {
            return List.of();
        }
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        if (object instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)object;
            container.cacheStructure(monitor, 3);
            Collection children = container.getChildren(monitor);
            if (children == null) {
                return result;
            }
            for (DBSObject dbsObject : children) {
                result.addAll(RAGUtils.flattenContainer(monitor, dbsObject));
            }
        } else {
            result.add(object);
        }
        return result;
    }
}

