/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai;

import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatMessage;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptGenerateSql;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.StringUtils;

public class AIChatConversation {
    @NotNull
    private final UUID uuid;
    @NotNull
    private String caption;
    @NotNull
    private final AIPromptGenerator promptGenerator;
    @NotNull
    private final List<AIChatMessage> messages;
    @Nullable
    private final DBPDataSourceContainer container;
    private final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    @NotNull
    private final LocalDateTime time;
    @Nullable
    private AIChatConversationSettings customSettings;
    private int nextMessageId;

    public AIChatConversation(@NotNull String caption, @NotNull AIPromptGenerator promptGenerator, @NotNull List<AIChatMessage> messages, @Nullable DBPDataSourceContainer container) {
        this(UUID.randomUUID(), caption, promptGenerator, messages, container, 0);
    }

    public AIChatConversation(@NotNull String caption, @NotNull AIPromptGenerator promptGenerator, @Nullable DBPDataSourceContainer container) {
        this(caption, promptGenerator, List.of(), container);
    }

    public AIChatConversation(@NotNull UUID uuid, @NotNull String caption, @NotNull AIPromptGenerator promptGenerator, @NotNull List<AIChatMessage> messages, @Nullable DBPDataSourceContainer container, int nextMessageId) {
        this.uuid = uuid;
        this.caption = caption;
        this.promptGenerator = promptGenerator;
        this.container = container;
        this.messages = new ArrayList<AIChatMessage>(messages);
        this.time = LocalDateTime.now();
        this.nextMessageId = nextMessageId;
    }

    @NotNull
    public UUID getId() {
        return this.uuid;
    }

    @NotNull
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(@NotNull String caption) {
        this.caption = caption;
    }

    @NotNull
    public AIPromptGenerator getPromptGenerator() {
        return this.promptGenerator;
    }

    @NotNull
    public List<AIChatMessage> getMessages() {
        return this.messages;
    }

    public AIChatMessage addMessage(AIMessage message) {
        if (this.messages.isEmpty() && this.promptGenerator instanceof AIPromptGenerateSql) {
            String displayMessage = message.getRawDisplayMessage();
            String newCaption = !CommonUtils.isEmpty((String)displayMessage) ? displayMessage : message.getContent();
            this.caption = StringUtils.truncateToSpace((String)newCaption, (int)40);
        }
        AIChatMessage chatMessage = new AIChatMessage(this.nextMessageId, message);
        ++this.nextMessageId;
        this.messages.add(chatMessage);
        return chatMessage;
    }

    public boolean removeMessage(@NotNull AIChatMessage message) {
        return this.messages.remove(message);
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public void clearMessagesAfter(@NotNull AIChatMessage message) {
        int index = this.messages.indexOf(message);
        while (this.messages.size() > index) {
            this.messages.removeLast();
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSource() {
        return this.container;
    }

    public int getNextMessageId() {
        return this.nextMessageId;
    }

    @NotNull
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @Nullable
    public Object getMeta(@NotNull String name) {
        return this.meta.get(name);
    }

    public void setMeta(@NotNull String name, @NotNull Object value) {
        this.meta.put(name, value);
    }

    @NotNull
    public LocalDateTime getTime() {
        return this.time;
    }

    @Nullable
    public AIChatConversationSettings getCustomSettings() {
        return this.customSettings;
    }

    public void setCustomSettings(@Nullable AIChatConversationSettings customSettings) {
        this.customSettings = customSettings;
    }

    public String toString() {
        return "AIChatConversation[uuid=" + String.valueOf(this.uuid) + ", caption=" + this.caption + ", promptGenerator=" + this.promptGenerator.generatorId() + ", messages=" + String.valueOf(this.messages) + ", container=" + String.valueOf(this.container) + "]";
    }

    @NotNull
    public LocalDateTime getLastMessageTime() {
        return this.messages.isEmpty() ? LocalDateTime.MIN : this.messages.getLast().message().getTime();
    }

    public boolean isTemporary() {
        return this.getDataSource() != null && this.getDataSource().isTemporary();
    }
}

