/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini;

import com.dbeaver.model.ai.engine.gemini.dto.GeminiCandidate;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerateRequest;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerateResponse;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiModel;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiModels;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiStreamChunk;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AbstractHttpAIClient;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class GeminiClient
extends AbstractHttpAIClient {
    private static final Log log = Log.getLog(GeminiClient.class);
    private static final String DATA_EVENT = "data: ";
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    private static final String MODEL_URL = "https://generativelanguage.googleapis.com/v1beta/";
    private static final String MODEL_DISCOVERY_URL = "https://generativelanguage.googleapis.com/v1beta/models";
    private static Map<String, GeminiModel> models = new LinkedHashMap<String, GeminiModel>();

    GeminiGenerateResponse generateContent(DBRProgressMonitor monitor, String encodedToken, GeminiGenerateRequest generateRequest, String modelName) throws DBException {
        URI uri = AIHttpUtils.resolve((String)(MODEL_URL + modelName + ":generateContent?key=" + encodedToken), (String[])new String[0]);
        HttpRequest request = HttpRequest.newBuilder().header("Content-type", "application/json").uri(uri).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)generateRequest))).timeout(TIMEOUT).build();
        return (GeminiGenerateResponse)GSON.fromJson(this.client.send(monitor, request), GeminiGenerateResponse.class);
    }

    void generateStreamContent(@NotNull DBRProgressMonitor monitor, @NotNull String encodedToken, @NotNull GeminiGenerateRequest generateRequest, @NotNull String modelName, @NotNull AIEngineResponseConsumer listener) throws DBException {
        URI uri = AIHttpUtils.resolve((String)(MODEL_URL + modelName + ":streamGenerateContent?alt=sse&key=" + encodedToken), (String[])new String[0]);
        HttpRequest request = HttpRequest.newBuilder().header("Content-type", "application/json").uri(uri).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)generateRequest))).timeout(TIMEOUT).build();
        this.client.sendAsync(request, line -> {
            if (line.startsWith(DATA_EVENT)) {
                String data = line.substring(6).trim();
                try {
                    GeminiStreamChunk chunk = (GeminiStreamChunk)GSON.fromJson(data, GeminiStreamChunk.class);
                    List contentParts = chunk.candidates().getFirst().content().parts().stream().toList();
                    if (((GeminiCandidate.ContentPart)contentParts.getFirst()).functionCall() != null) {
                        listener.nextChunk(new AIEngineResponseChunk(new AIFunctionCall(((GeminiCandidate.ContentPart)contentParts.getFirst()).functionCall().name(), ((GeminiCandidate.ContentPart)contentParts.getFirst()).functionCall().args())));
                    } else {
                        listener.nextChunk(new AIEngineResponseChunk(contentParts.stream().map(GeminiCandidate.ContentPart::text).toList()));
                    }
                    boolean finished = chunk.candidates().stream().findFirst().map(it -> "STOP".equals(it.finishReason())).orElse(false);
                    if (finished) {
                        listener.close();
                    }
                }
                catch (Exception e) {
                    listener.error((Throwable)e);
                }
            }
        }, arg_0 -> ((AIEngineResponseConsumer)listener).error(arg_0), () -> ((AIEngineResponseConsumer)listener).close());
    }

    @NotNull
    public GeminiModel getModelInformation(@NotNull String modelName, @NotNull DBRProgressMonitor monitor, @NotNull String token) throws DBException {
        if (!models.isEmpty() && models.containsKey(modelName)) {
            return models.get(modelName);
        }
        if (!models.isEmpty()) {
            throw new DBException("Model not found: " + modelName);
        }
        return this.loadModels(monitor, token).stream().filter(it -> it.name().equals(modelName)).findFirst().orElseThrow(() -> new DBException("Model not found: " + modelName));
    }

    public List<GeminiModel> loadModels(@NotNull DBRProgressMonitor monitor, @NotNull String token) throws DBException {
        URI uri = AIHttpUtils.resolve((String)("https://generativelanguage.googleapis.com/v1beta/models?key=" + token + "&pageSize=1000"), (String[])new String[0]);
        String responseBody = this.client.send(monitor, HttpRequest.newBuilder().header("Content-type", "application/json").uri(uri).timeout(TIMEOUT).build());
        GeminiModels geminiModels = (GeminiModels)GSON.fromJson(responseBody, GeminiModels.class);
        List<GeminiModel> geminiModelList = geminiModels.filterByChat();
        models = geminiModelList.stream().collect(LinkedHashMap::new, (map, model) -> {
            GeminiModel geminiModel = map.put(model.name(), model);
        }, HashMap::putAll);
        return geminiModelList;
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    @NotNull
    protected DBException mapHttpError(int statusCode, @NotNull String body) {
        log.debug((Object)("Gemini request failed: " + statusCode + ", " + body));
        return new DBException("Gemini request failed: " + AIHttpUtils.parseOpenAIStyleErrorMessage((String)body));
    }
}

