/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.ollama;

import com.dbeaver.model.ai.engine.ollama.OllamaClient;
import com.dbeaver.model.ai.engine.ollama.OllamaProperties;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatRequest;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatResponse;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OllamaCompletionEngine
extends BaseCompletionEngine<OllamaProperties> {
    private final DisposableLazyValue<OllamaClient, DBException> client = new DisposableLazyValue<OllamaClient, DBException>(){

        @NotNull
        protected OllamaClient initialize() {
            return new OllamaClient(((OllamaProperties)OllamaCompletionEngine.this.properties).getHostname());
        }

        protected void onDispose(@NotNull OllamaClient disposedValue) {
            disposedValue.close();
        }
    };

    public OllamaCompletionEngine(@NotNull OllamaProperties properties) {
        super((AIEngineProperties)properties);
    }

    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) {
        return List.of();
    }

    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        OllamaChatRequest chatRequest = OllamaChatRequest.builder().addMessages(request.getMessages()).options(((OllamaProperties)this.properties).getTemperature(), ((OllamaProperties)this.properties).getContextWindowSize()).model(((OllamaProperties)this.properties).getModel()).build();
        OllamaChatResponse chat = ((OllamaClient)((Object)this.client.getInstance())).chat(monitor, chatRequest);
        return new AIEngineResponse(AIMessageType.ASSISTANT, List.of(chat.message().content()));
    }

    public void requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request, @NotNull AIEngineResponseConsumer listener) throws DBException {
        OllamaChatRequest chatRequest = OllamaChatRequest.builder().addMessages(request.getMessages()).options(((OllamaProperties)this.properties).getTemperature(), ((OllamaProperties)this.properties).getContextWindowSize()).model(((OllamaProperties)this.properties).getModel()).stream(true).build();
        ((OllamaClient)((Object)this.client.getInstance())).createChatCompletionStream(monitor, chatRequest, listener);
    }

    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OllamaProperties)this.properties).getContextWindowSize();
    }

    public void close() throws DBException {
        this.client.dispose();
    }
}

