/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.impl;

import com.dbeaver.model.ai.impl.SampleDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.ai.AISchemaGenerationOptions;
import org.jkiss.dbeaver.model.ai.impl.AISchemaGeneratorImpl;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class AISchemaGeneratorProImpl
extends AISchemaGeneratorImpl {
    private static final Map<DBPDataSource, SampleDataProvider> SAMPLE_DATA_PROVIDERS = new ConcurrentHashMap<DBPDataSource, SampleDataProvider>();

    @NotNull
    public String describeTable(@NotNull DBRProgressMonitor monitor, @NotNull DBSTable table, @Nullable DBCExecutionContext ctx, @NotNull AISchemaGenerationOptions options, boolean useFqn) throws DBException {
        String base = super.describeTable(monitor, table, ctx, options, useFqn);
        if (CommonUtils.isEmpty((String)base)) {
            return base;
        }
        int lastParen = base.lastIndexOf(41);
        String ddlStart = lastParen >= 0 ? base.substring(0, lastParen) : base;
        StringJoiner joiner = new StringJoiner(",", "", ");");
        joiner.add(ddlStart);
        if (options.sendConstraints()) {
            this.describeTableKeys(monitor, (DBSEntity)table).forEach(joiner::add);
        }
        if (options.sendForeignKeys()) {
            this.describeForeignKeys(monitor, (DBSEntity)table).forEach(joiner::add);
        }
        return joiner.toString();
    }

    private List<String> describeTableKeys(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        Collection constraints = entity.getConstraints(monitor);
        if (CommonUtils.isEmpty((Collection)constraints)) {
            return List.of();
        }
        ArrayList<String> keyDescriptions = new ArrayList<String>(constraints.size());
        for (DBSEntityConstraint c : constraints) {
            String description = this.describeConstraint(monitor, c);
            if (CommonUtils.isEmpty((String)description)) continue;
            keyDescriptions.add(description);
        }
        return keyDescriptions;
    }

    @Nullable
    private String describeConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityConstraint constraint) throws DBException {
        DBSEntityConstraintType type = constraint.getConstraintType();
        if (type != DBSEntityConstraintType.PRIMARY_KEY && type != DBSEntityConstraintType.UNIQUE_KEY) {
            return null;
        }
        List refs = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor);
        if (CommonUtils.isEmpty((Collection)refs)) {
            return null;
        }
        String attrs = refs.stream().map(DBSEntityAttributeRef::getAttribute).filter(Objects::nonNull).map(DBPNamedObject::getName).collect(Collectors.joining(", ", "(", ")"));
        return (type == DBSEntityConstraintType.PRIMARY_KEY ? "PRIMARY KEY " : "UNIQUE ") + attrs;
    }

    @NotNull
    private List<String> describeForeignKeys(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity object) throws DBException {
        Collection associations = object.getAssociations(monitor);
        if (associations == null || associations.isEmpty()) {
            return List.of();
        }
        ArrayList<String> fkDdls = new ArrayList<String>(associations.size());
        for (DBSEntityAssociation association : associations) {
            String fkDescription = this.describeForeignKey(monitor, association);
            if (CommonUtils.isEmpty((String)fkDescription)) continue;
            fkDdls.add(fkDescription);
        }
        return fkDdls;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String describeForeignKey(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        void referrer;
        if (!(association instanceof DBSEntityReferrer)) {
            return null;
        }
        DBSEntityReferrer dBSEntityReferrer = (DBSEntityReferrer)association;
        StringBuilder description = new StringBuilder();
        DBSEntity refEntity = association.getAssociatedEntity();
        List refAttrs = referrer.getAttributeReferences(monitor);
        if (refEntity == null || CommonUtils.isEmpty((Collection)refAttrs)) {
            return null;
        }
        String attrs = refAttrs.stream().map(DBSEntityAttributeRef::getAttribute).filter(Objects::nonNull).map(DBPNamedObject::getName).collect(Collectors.joining(", ", "(", ")"));
        description.append("FOREIGN KEY ").append(attrs).append(" REFERENCES ").append(refEntity.getName());
        return description.toString();
    }
}

