/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.prompt;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptGenerateSql;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;

public class AIPromptFixSqlError
extends AIPromptAbstract {
    public static final String[] SQL_FIX_GOALS = new String[]{"Help users to fix errors in SQL queries.", "Generate correct query following the main idea of original query.", "Provide information about database performance tuning and optimization."};

    public static AIMessage createErrorExplainMessage(@NotNull String errorMessage, @NotNull String query) {
        String displayMessage = "Please explain what is wrong with the following SQL query and suggest a fix for the error:\n```\n%s\n```\nThe error message is:\n```\n%s\n```\n".formatted(query, errorMessage);
        String message = displayMessage + "\nKeep the answer simple and straightforward; don't need to explain the error in details. Don't provide partial queries that can't be directly executed.";
        return AIMessage.userAutoMessage((String)message, (String)displayMessage);
    }

    @NotNull
    public String generatorId() {
        return "sql-fix";
    }

    @NotNull
    public static AIPromptFixSqlError create(@NotNull DBSLogicalDataSourceSupplier dsSupplier) {
        AIPromptFixSqlError builder = new AIPromptFixSqlError();
        DBSLogicalDataSource dataSource = (DBSLogicalDataSource)dsSupplier.get();
        if (dataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo((DBSLogicalDataSource)dataSource)).addInstructions(AIPromptUtils.createGenerateQueryInstructions((DBSLogicalDataSource)dataSource));
        }
        builder.addGoals(SQL_FIX_GOALS).addOutputFormats(AIPromptGenerateSql.SQL_OUTPUT_FORMATS);
        return builder;
    }
}

