/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.prompt.dt;

import com.dbeaver.model.ai.AIAssistantPro;
import com.dbeaver.model.ai.prompt.dt.DTTContainer;
import com.dbeaver.model.ai.prompt.dt.ResolveTargetTypeRequest;
import com.dbeaver.model.ai.prompt.dt.ResolveTargetTypeResponse;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIAssistantResponse;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AIPromptResolveDataTypes
extends AIPromptAbstract {
    public static ResolveTargetTypeResponse resolveTargetType(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull ResolveTargetTypeRequest request) throws DBException {
        AIPromptResolveDataTypes prompt;
        AIAssistantPro assistant = (AIAssistantPro)AIAssistantRegistry.getInstance().createAssistant(workspace);
        AIAssistantResponse result = assistant.generateText(monitor, null, (AIPromptGenerator)(prompt = AIPromptResolveDataTypes.create(request)), List.of());
        if (!result.isText()) {
            throw new DBException("Failed to resolve data types: " + String.valueOf(result));
        }
        ResolveTargetTypeResponse response = (ResolveTargetTypeResponse)JSONUtils.GSON.fromJson(AITextUtils.extractCode((String)result.getText()), ResolveTargetTypeResponse.class);
        if (response == null) {
            throw new DBException("Failed to resolve target types: empty AI engine response");
        }
        return response;
    }

    @NotNull
    public String generatorId() {
        return "resolve-types";
    }

    @NotNull
    public static AIPromptResolveDataTypes create(@NotNull ResolveTargetTypeRequest request) throws DBException {
        boolean sendSampleData = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.description");
        StringBuilder snapshot = new StringBuilder();
        for (DTTContainer dttContainer : request.tablesToTransfer()) {
            snapshot.append(dttContainer.asString(sendSampleData));
            snapshot.append("\n");
        }
        AIPromptResolveDataTypes builder = new AIPromptResolveDataTypes();
        builder.addGoals(new String[]{"Provide a list of target types for the given source tables to migrate them to " + request.targetContainer().getDataSource().getContainer().getDriver().getFullName() + "."}).addContexts(new String[]{"The source container is " + request.sourceContainer().getSQLDialect().getDialectName(), "Source tables:\n " + String.valueOf(snapshot)}).addOutputFormats(new String[]{"Provide the target types in a JSON format.", "The table names and column names must be in original case.", "Example: " + JSONUtils.GSON.toJson((Object)ResolveTargetTypeResponse.example())});
        return builder;
    }
}

