/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBDataSourceConnection;
import com.dbeaver.model.tableau.TBDataSourceRevision;
import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.rest.api.ConnectionType;
import com.dbeaver.model.tableau.rest.api.DataSourceType;
import com.dbeaver.model.tableau.rest.api.ProjectType;
import com.dbeaver.model.tableau.rest.api.RevisionType;
import com.dbeaver.model.tableau.rest.api.TsRequest;
import com.dbeaver.model.tableau.tds.TDSGraphObject;
import com.dbeaver.model.tableau.tds.TDSModel;
import com.dbeaver.model.tableau.tds.TDSRelation;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.IOUtils;

public class TBDataSource
implements TBObject {
    private static final Log log = Log.getLog(TBDataSource.class);
    private final TBSite site;
    private final TBProject project;
    private DataSourceType dataSource;
    private TDSModel model;
    private Path dsFolder;
    private Path tdsFile;
    private boolean detailsLoaded;
    private List<TBDataSourceRevision> revisions;

    public TBDataSource(TBSite site, DataSourceType dataSource, TBProject project) {
        this.site = site;
        this.dataSource = dataSource;
        this.project = project;
    }

    public TBSite getSite() {
        return this.site;
    }

    public TBSession getSession() {
        return this.site.getSession();
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.dataSource.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return this.dataSource.getName();
    }

    @Property(order=30)
    @Nullable
    public String getDescription() {
        return this.dataSource.getDescription();
    }

    @Property(order=10)
    @Nullable
    public String getContentURL() {
        return this.dataSource.getContentUrl();
    }

    @Property(order=11, href=true)
    @Nullable
    public String getWebpageURL() {
        return this.dataSource.getWebpageUrl();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getCreatedAt() {
        return String.valueOf(this.dataSource.getCreatedAt());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getUpdatedAt() {
        return String.valueOf(this.dataSource.getUpdatedAt());
    }

    @Property(order=20)
    public TBProject getProject() {
        return this.project;
    }

    public List<TBDataSourceConnection> getConnections(DBRProgressMonitor monitor) throws DBException {
        return this.site.executeRequest(monitor, "datasources/" + this.getId() + "/connections").getConnections().getConnection().stream().map(ct -> new TBDataSourceConnection(this, (ConnectionType)ct)).collect(Collectors.toList());
    }

    public DataSourceType getDataSourceType() {
        return this.dataSource;
    }

    @Override
    public boolean needsDetails() {
        return !this.detailsLoaded;
    }

    @Override
    public void loadDetails(DBRProgressMonitor monitor) throws DBException {
        this.dataSource = this.site.executeRequest(monitor, "datasources/" + this.getId() + "?fields=_all_").getDatasource();
        this.detailsLoaded = true;
    }

    public TDSModel getModel(DBRProgressMonitor monitor) throws DBException {
        if (this.model == null) {
            this.model = this.loadTDS(monitor);
        }
        return this.model;
    }

    /*
     * Loose catch block
     */
    private TDSModel loadTDS(DBRProgressMonitor monitor) throws DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Response httpResponse = this.getSession().executeHttpRequest(this.site.makeSiteEndpoint("datasources/" + this.getId() + "/content"));){
            TDSModel tDSModel;
            InputStream is;
            Throwable throwable2;
            block21: {
                throwable2 = null;
                Object var6_10 = null;
                is = httpResponse.body().byteStream();
                tDSModel = this.parseTds(monitor, is);
                if (is == null) break block21;
                is.close();
            }
            return tDSModel;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new DBException("Error reading TDS", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private TDSModel parseTds(DBRProgressMonitor monitor, InputStream inputStream) throws IOException, DBException {
        Path tempFolder = this.getTempFolder(monitor);
        this.dsFolder = tempFolder.resolve("tableau-datasource-" + this.dataSource.getId());
        if (Files.exists(this.dsFolder, new LinkOption[0])) {
            IOUtils.deleteDirectory((Path)this.dsFolder);
        }
        Files.createDirectories(this.dsFolder, new FileAttribute[0]);
        monitor.subTask("Extract TDSX archive");
        IOUtils.extractZipArchive((InputStream)inputStream, (Path)this.dsFolder);
        Throwable throwable = null;
        Object var5_8 = null;
        try (Stream<Path> files = Files.list(this.dsFolder);){
            this.tdsFile = files.filter(f -> f.getFileName().toString().endsWith(".tds")).findFirst().orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.tdsFile != null) {
            monitor.subTask("Parse TDS");
            try {
                throwable = null;
                var5_8 = null;
                try (InputStream tdsStream = Files.newInputStream(this.tdsFile, new OpenOption[0]);){
                    return new TDSModel(this, tdsStream);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new DBException("Error parsing data source TDS", (Throwable)e);
            }
        }
        return new TDSModel(this);
    }

    @NotNull
    private Path getTempFolder(DBRProgressMonitor monitor) throws IOException {
        Path tempFolder = DBWorkbench.getPlatform().getTempFolder(monitor, "tableau");
        return tempFolder;
    }

    private void publishDataSource(DBRProgressMonitor monitor) throws DBException {
        if (this.tdsFile == null) {
            throw new DBException("No TDS file");
        }
        try {
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (OutputStream tdsStream = Files.newOutputStream(this.tdsFile, new OpenOption[0]);){
                this.model.saveModel(tdsStream);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Path tdsx = null;
            try {
                tdsx = Files.createTempFile(this.getTempFolder(monitor), this.dataSource.getId(), ".tdsx", new FileAttribute[0]);
                throwable2 = null;
                Object var4_8 = null;
                try (OutputStream tdsxOut = Files.newOutputStream(tdsx, new OpenOption[0]);){
                    IOUtils.zipFolder((File)this.dsFolder.toFile(), (OutputStream)tdsxOut);
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                this.publishTdsx(monitor, tdsx);
            }
            catch (Throwable throwable5) {
                if (tdsx != null) {
                    Files.delete(tdsx);
                }
                throw throwable5;
            }
            if (tdsx != null) {
                Files.delete(tdsx);
            }
        }
        catch (Exception e) {
            throw new DBException("IO error while TDSX", (Throwable)e);
        }
    }

    private void publishTdsx(DBRProgressMonitor monitor, Path tdsx) throws DBException {
        String dsUploadForm;
        try {
            TsRequest tsRequest = new TsRequest();
            DataSourceType dsRef = new DataSourceType();
            dsRef.setId(this.getId());
            dsRef.setName(this.getName());
            ProjectType projectRef = new ProjectType();
            projectRef.setId(this.getProject().getId());
            dsRef.setProject(projectRef);
            tsRequest.setDatasource(dsRef);
            StringWriter out = new StringWriter();
            this.site.getSession().createMarshaller().marshal((Object)tsRequest, (Writer)out);
            dsUploadForm = out.toString();
        }
        catch (JAXBException e) {
            throw new DBException("Cannot marshal TSDX upload request", (Throwable)e);
        }
        this.site.getSession().executeFileRequest(monitor, this.site.makeSiteEndpoint("datasources?overwrite=true&datasourceType=tdsx"), dsUploadForm, tdsx);
        log.debug((Object)("TSDX uploaded: " + tdsx.toString()));
    }

    public List<TBDataSourceRevision> getRevisions(DBRProgressMonitor monitor) throws DBException {
        if (this.revisions == null) {
            this.revisions = this.site.getSession().executeRequest(monitor, this.site.makeSiteEndpoint("datasources/" + this.getId() + "/revisions")).getRevisions().getRevision().stream().map(p -> new TBDataSourceRevision(this, (RevisionType)p)).collect(Collectors.toList());
        }
        return this.revisions;
    }

    public void updateCustomQueryText(DBRProgressMonitor monitor, TDSRelation relation, String content) throws DBException {
        monitor.beginTask("Publish Tableau datasource", 2);
        monitor.subTask("Update TDS model");
        TDSModel model = this.getModel(monitor);
        TDSRelation legacyRelation = model.getRelation(relation.getName(), true);
        TDSGraphObject customGO = model.getGraphObject(relation);
        relation.setCustomQueryText(content);
        if (legacyRelation != null) {
            legacyRelation.setCustomQueryText(content);
        }
        if (customGO != null && customGO.getRelation() != null) {
            customGO.getRelation().setCustomQueryText(content);
        }
        monitor.worked(1);
        monitor.subTask("Publish TDSX");
        this.publishDataSource(monitor);
        monitor.worked(1);
        monitor.done();
    }

    public void refreshObject() {
        this.model = null;
        this.revisions = null;
    }
}

