/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import com.dbeaver.model.tableau.navigator.DBNTableauConnectionRelationNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.model.tableau.tds.TDSRelation;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.utils.CommonUtils;

public class DBNTableauDataSourceConnectionNode
extends DBNTableauAbstractNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauDataSourceConnectionNode.class);
    private final TDSConnection connection;
    private DBNTableauConnectionRelationNode[] children;

    DBNTableauDataSourceConnectionNode(DBRProgressMonitor monitor, DBNTableauDataSourceNode parentNode, TDSConnection connection) {
        super(parentNode);
        this.connection = connection;
        this.autoAssignDataSource(monitor);
    }

    public TDSConnection getConnection() {
        return this.connection;
    }

    private void autoAssignDataSource(DBRProgressMonitor monitor) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("tableau.autoAssociateConnections")) {
            return;
        }
        DBPDataSourceRegistry registry = this.getOwnerProject().getDataSourceRegistry();
        List<DBPDataSourceContainer> dsList = TBUtils.getAssociatedDataSources(registry, this.connection);
        if (dsList.isEmpty()) {
            Map<String, String> properties = this.connection.getProperties();
            DBPDriver driver = this.connection.getConnectionDriver();
            if (driver != null) {
                String dbServer = properties.get("server");
                String dbPort = properties.get("port");
                String dbDatabase = properties.get("dbname");
                if (!CommonUtils.isEmpty((String)dbServer)) {
                    for (DBPDataSourceContainer ds : registry.getDataSources()) {
                        DBPConnectionConfiguration cc;
                        if (ds.getDriver() != driver || !CommonUtils.equalObjects((Object)dbServer, (Object)(cc = ds.getConnectionConfiguration()).getHostName()) || !CommonUtils.equalObjects((Object)dbPort, (Object)cc.getHostPort()) || !CommonUtils.equalObjects((Object)dbDatabase, (Object)cc.getDatabaseName())) continue;
                        try {
                            TBUtils.linkDataSourceWithConnection(monitor, ds, this.connection);
                            DBWorkbench.getPlatformUI().showNotification("Database connection found", ds.getName() + " associated with '" + this.getNodeDisplayName() + "'", false, () -> {
                                UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                                if (serviceConnections != null) {
                                    serviceConnections.openConnectionEditor(ds, "com.dbeaver.ui.tableau.pref.TableauDataSourcePreferencePage");
                                }
                            });
                        }
                        catch (Exception e) {
                            log.error((Object)"Error while associating Tableau connection with data source", (Throwable)e);
                        }
                        break;
                    }
                }
            }
        }
    }

    TBDataSource getDataSource() {
        return this.getParentNode().getDataSource();
    }

    @Nullable
    public DBNTableauDataSourceNode getParentNode() {
        return (DBNTableauDataSourceNode)super.getParentNode();
    }

    @NotNull
    public String getNodeType() {
        return "Tableau connection";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.connection.getCaption();
    }

    @Nullable
    public String getNodeDescription() {
        return null;
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_SCHEMA;
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }

    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            TBDataSource dataSource = this.getDataSource();
            this.children = (DBNTableauConnectionRelationNode[])dataSource.getModel(monitor).getConnectionRelations(this.connection).stream().map(r -> new DBNTableauConnectionRelationNode(this, dataSource, (TDSRelation)r, this.connection)).toArray(DBNTableauConnectionRelationNode[]::new);
        }
        return this.children;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.children = null;
        this.getDataSource().refreshObject();
        return super.refreshNode(monitor, source);
    }

    public TDSConnection getNodeObject() {
        return this.connection;
    }

    public List<DBPDataSourceContainer> getAssociatedDataSources() {
        return TBUtils.getAssociatedDataSources(this.getOwnerProject().getDataSourceRegistry(), this.connection);
    }
}

