/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.navigator.DBNTableauFolderNode;
import com.dbeaver.model.tableau.navigator.DBNTableauSiteNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNTableauDataSourceNode
extends DBNTableauAbstractNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauDataSourceNode.class);
    private final TBDataSource dataSource;
    private DBNTableauDataSourceConnectionNode[] children;

    DBNTableauDataSourceNode(DBNTableauFolderNode<DBNTableauSiteNode> parentNode, TBDataSource dataSource) {
        super(parentNode);
        this.dataSource = dataSource;
    }

    public TBDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getNodeType() {
        return "Tableau data source";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.dataSource.getName();
    }

    @Nullable
    public String getNodeDescription() {
        return this.dataSource.getDescription();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_DATABASE;
    }

    protected boolean allowsChildren() {
        return true;
    }

    public TBDataSource getNodeObject() {
        return this.dataSource;
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }

    @Nullable
    public DBNTableauDataSourceConnectionNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = (DBNTableauDataSourceConnectionNode[])this.getNodeObject().getModel(monitor).getNamedConnections().stream().map(ds -> new DBNTableauDataSourceConnectionNode(monitor, this, (TDSConnection)ds)).toArray(DBNTableauDataSourceConnectionNode[]::new);
        }
        return this.children;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.children = null;
        this.dataSource.refreshObject();
        return super.refreshNode(monitor, source);
    }
}

