/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.auth.TBAuthConfiguration;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.auth.TBConfigurationListener;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceNode;
import com.dbeaver.model.tableau.navigator.DBNTableauFolderNode;
import com.dbeaver.model.tableau.navigator.DBNTableauProfileNode;
import com.dbeaver.model.tableau.navigator.DBNTableauSiteNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class DBNTableauRootNode
extends DBNNode
implements DBPHiddenObject,
TBConfigurationListener {
    private static final Log log = Log.getLog(DBNTableauRootNode.class);
    private DBNTableauProfileNode[] profiles;

    DBNTableauRootNode(DBNProject parentNode) {
        super((DBNNode)parentNode);
        TBAuthConfiguration.getConfiguration().addListener(this);
    }

    protected void dispose(boolean reflect) {
        super.dispose(reflect);
        TBAuthConfiguration.getConfiguration().removeListener(this);
    }

    @NotNull
    public String getNodeType() {
        return "tableau";
    }

    @NotNull
    public String getNodeDisplayName() {
        return "Tableau";
    }

    @Nullable
    public String getNodeDescription() {
        return "Cloud explorer";
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return null;
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNTableauProfileNode[] getChildren(@NotNull DBRProgressMonitor monitor) {
        if (this.profiles == null && !monitor.isForceCacheUsage()) {
            this.profiles = (DBNTableauProfileNode[])TBAuthConfiguration.getConfiguration().getGlobalProfiles().stream().map(p -> new DBNTableauProfileNode(this, (TBAuthProfile)p)).toArray(DBNTableauProfileNode[]::new);
        }
        return this.profiles;
    }

    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return DBNNode.NodePathType.ext.getPrefix() + this.getNodeDisplayName();
    }

    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.refreshProfiles();
        return this;
    }

    public void refreshProfiles() {
    }

    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }

    public boolean isHidden() {
        return true;
    }

    @Override
    public void profileAction(TBConfigurationListener.Action action, TBAuthProfile profile) {
        if (this.profiles == null) {
            return;
        }
        switch (action) {
            case ADD: {
                DBNTableauProfileNode newNode = new DBNTableauProfileNode(this, profile);
                this.profiles = (DBNTableauProfileNode[])ArrayUtils.add(DBNTableauProfileNode.class, (Object[])this.profiles, (Object)((Object)newNode));
                DBNEvent event = new DBNEvent((Object)this, DBNEvent.Action.ADD, (DBNNode)newNode);
                this.getModel().fireNodeEvent(event);
                break;
            }
            case DELETE: {
                DBNTableauProfileNode profileNode = this.getProfileNode(profile);
                if (profileNode == null) break;
                this.profiles = (DBNTableauProfileNode[])ArrayUtils.remove(DBNTableauProfileNode.class, (Object[])this.profiles, (Object)((Object)profileNode));
                this.getModel().fireNodeEvent(new DBNEvent((Object)this, DBNEvent.Action.REMOVE, (DBNNode)profileNode));
                break;
            }
            case UPDATE: {
                DBNTableauProfileNode profileNode = this.getProfileNode(profile);
                if (profileNode == null) break;
                this.getModel().fireNodeUpdate((Object)this, (DBNNode)profileNode, DBNEvent.NodeChange.REFRESH);
            }
        }
    }

    private DBNTableauProfileNode getProfileNode(TBAuthProfile profile) {
        return Arrays.stream(this.profiles).filter(pn -> pn.getNodeObject().equals(profile)).findFirst().orElse(null);
    }

    @Nullable
    public DBNTableauDataSourceConnectionNode findConnectionNode(DBRProgressMonitor monitor, TDSConnection tdsConnection) throws DBException {
        DBNTableauProfileNode[] children = this.getChildren(monitor);
        if (children == null) {
            return null;
        }
        DBNTableauProfileNode profileNode = Arrays.stream(children).filter(p -> p.getProfile().equals(tdsConnection.getDataSource().getSession().getAuthProfile())).findFirst().orElse(null);
        if (profileNode == null) {
            return null;
        }
        DBNTableauSiteNode[] siteNodes = profileNode.getChildren(monitor);
        if (siteNodes == null) {
            return null;
        }
        DBNTableauSiteNode siteNode = Arrays.stream(siteNodes).filter(p -> p.getSite().equals(tdsConnection.getDataSource().getSite())).findFirst().orElse(null);
        if (siteNode == null) {
            return null;
        }
        DBNTableauFolderNode<?> folderNode = siteNode.getFolderNode(monitor, DBNTableauSiteNode.FOLDER_DATASOURCES);
        if (folderNode == null) {
            return null;
        }
        DBNTableauDataSourceNode dataSourceNode = null;
        for (DBNNode dsNode : ArrayUtils.safeArray((Object[])folderNode.getChildren(monitor))) {
            if (!(dsNode instanceof DBNTableauDataSourceNode) || ((DBNTableauDataSourceNode)dsNode).getDataSource() != tdsConnection.getDataSource()) continue;
            dataSourceNode = (DBNTableauDataSourceNode)dsNode;
            break;
        }
        if (dataSourceNode == null) {
            return null;
        }
        DBNTableauDataSourceConnectionNode[] dsNodes = dataSourceNode.getChildren(monitor);
        if (dsNodes == null) {
            return null;
        }
        return Arrays.stream(dsNodes).filter(p -> p.getConnection().equals(tdsConnection)).findFirst().orElse(null);
    }
}

