/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBView;
import com.dbeaver.model.tableau.TBWorkbook;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import com.dbeaver.model.tableau.navigator.DBNTableauFolderNode;
import com.dbeaver.model.tableau.navigator.DBNTableauSiteNode;
import com.dbeaver.model.tableau.navigator.DBNTableauViewNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNTableauWorkbookNode
extends DBNTableauAbstractNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauWorkbookNode.class);
    private final TBWorkbook workbook;
    private DBNNode[] children;

    DBNTableauWorkbookNode(DBNTableauFolderNode<DBNTableauSiteNode> parentNode, TBWorkbook workbook) {
        super(parentNode);
        this.workbook = workbook;
    }

    @NotNull
    public String getNodeType() {
        return "Tableau workbook";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.workbook.getName();
    }

    @Nullable
    public String getNodeDescription() {
        return this.workbook.getDescription();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_SCHEMA;
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = (DBNNode[])((DBNTableauSiteNode)this.getParentNode().getParentNode()).getSite().getViews(monitor, this.workbook).stream().map(ds -> new DBNTableauViewNode(this, (TBView)ds)).toArray(DBNTableauViewNode[]::new);
        }
        return this.children;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.children = null;
        return super.refreshNode(monitor, source);
    }

    public Object getNodeObject() {
        return this.workbook;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }
}

