/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.tds;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.model.tableau.tds.TDSGraphObject;
import com.dbeaver.model.tableau.tds.TDSRelation;
import com.dbeaver.model.tableau.tds.TDSRelationType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TDSModel {
    private final TBDataSource dataSource;
    private Document tdsDocument;
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final Map<String, TDSConnection> namedConnections = new LinkedHashMap<String, TDSConnection>();
    private final List<TDSRelation> relations = new ArrayList<TDSRelation>();
    private final List<TDSRelation> legacyRelations = new ArrayList<TDSRelation>();
    private boolean hasNonLegacyRelations = false;
    private final List<TDSGraphObject> graphObjects = new ArrayList<TDSGraphObject>();

    public TDSModel(TBDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TDSModel(TBDataSource dataSource, InputStream inputStream) throws Exception {
        this(dataSource);
        this.parseTDS(inputStream);
    }

    public TBDataSource getDataSource() {
        return this.dataSource;
    }

    public Document getTdsDocument() {
        return this.tdsDocument;
    }

    public List<TDSConnection> getNamedConnections() {
        return new ArrayList<TDSConnection>(this.namedConnections.values());
    }

    public List<TDSRelation> getRelations() {
        return this.relations;
    }

    public List<TDSRelation> getLegacyRelations() {
        return this.legacyRelations;
    }

    public List<TDSRelation> getConnectionRelations(TDSConnection connection) {
        return this.relations.stream().filter(c -> (!this.hasNonLegacyRelations || !c.isLegacy()) && c.getConnectionId().equals(connection.getName())).collect(Collectors.toList());
    }

    public TDSRelation getRelation(String name, boolean legacy) {
        List<TDSRelation> relList = legacy ? this.legacyRelations : this.relations;
        for (TDSRelation relation : relList) {
            if (!relation.getName().equals(name)) continue;
            return relation;
        }
        return null;
    }

    public TDSRelation getRelation(String name) {
        return this.getRelation(name, false);
    }

    public List<TDSGraphObject> getGraphObjects() {
        return this.graphObjects;
    }

    public TDSGraphObject getGraphObject(TDSRelation relation) {
        for (TDSGraphObject object : this.graphObjects) {
            if (object.getRelation() == null || !object.getRelation().equals(relation)) continue;
            return object;
        }
        return null;
    }

    private void parseTDS(InputStream inputStream) throws Exception {
        Element objectGraphElem;
        factory.setValidating(false);
        this.tdsDocument = factory.newDocumentBuilder().parse(inputStream);
        Element rootElem = this.tdsDocument.getDocumentElement();
        Element connectionElem = XMLUtils.getChildElement((Element)rootElem, (String)"connection");
        Element namedConnectionsElem = XMLUtils.getChildElement((Element)connectionElem, (String)"named-connections");
        for (Element namedConnectionElem : XMLUtils.getChildElementList((Element)namedConnectionsElem, (String)"named-connection")) {
            Iterator dsConnection = new TDSConnection(this.dataSource, namedConnectionElem);
            this.namedConnections.put(((TDSConnection)((Object)dsConnection)).getName(), (TDSConnection)((Object)dsConnection));
        }
        Element rootRelationsElem = XMLUtils.getChildElement((Element)connectionElem, (String)"relation");
        for (Element relationElem : XMLUtils.getChildElementList((Element)rootRelationsElem, (String)"relation")) {
            TDSRelation dsRelation = new TDSRelation(this, relationElem);
            this.relations.add(dsRelation);
            this.hasNonLegacyRelations = true;
        }
        if (this.relations.isEmpty()) {
            for (Element relationElem : XMLUtils.getChildElementList((Element)connectionElem, (String)"_.fcp.ObjectModelEncapsulateLegacy.false...relation")) {
                this.parseNestedRelations(relationElem, false);
            }
            Element legacyRelations = XMLUtils.getChildElement((Element)connectionElem, (String)"_.fcp.ObjectModelEncapsulateLegacy.true...relation");
            if (legacyRelations != null) {
                this.parseNestedRelations(legacyRelations, true);
            }
        }
        if ((objectGraphElem = XMLUtils.getChildElement((Element)rootElem, (String)"object-graph")) == null) {
            objectGraphElem = XMLUtils.getChildElement((Element)rootElem, (String)"_.fcp.ObjectModelEncapsulateLegacy.true...object-graph");
        }
        Element objectsElem = XMLUtils.getChildElement((Element)objectGraphElem, (String)"objects");
        for (Element objectElem : XMLUtils.getChildElementList((Element)objectsElem, (String)"object")) {
            TDSGraphObject dsGraphObject = new TDSGraphObject(this, objectElem);
            this.graphObjects.add(dsGraphObject);
        }
    }

    private void parseNestedRelations(Element relationsElem, boolean entities) {
        List<TDSRelation> toList;
        if (relationsElem == null) {
            return;
        }
        List<TDSRelation> list = toList = entities ? this.relations : this.legacyRelations;
        if (relationsElem.hasAttribute("connection")) {
            toList.add(new TDSRelation(this, relationsElem, true));
        }
        block3: for (Element relationElem : XMLUtils.getChildElementList((Element)relationsElem, (String)"relation")) {
            TDSRelationType relationType = (TDSRelationType)CommonUtils.valueOf(TDSRelationType.class, (String)relationElem.getAttribute("type"), (Enum)TDSRelationType.none);
            switch (relationType) {
                case join: {
                    for (Element joinElem : XMLUtils.getChildElementList((Element)relationElem, (String)"relation")) {
                        if (!joinElem.hasAttribute("connection") || "table".equals(joinElem.getAttribute("type"))) continue;
                        toList.add(new TDSRelation(this, joinElem, true));
                    }
                    continue block3;
                }
                default: {
                    if (!relationElem.hasAttribute("connection")) continue block3;
                    toList.add(new TDSRelation(this, relationElem, true));
                }
            }
        }
    }

    public void saveModel(OutputStream os) throws Exception {
        DOMSource source = new DOMSource(this.tdsDocument);
        StreamResult result = new StreamResult(os);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(source, result);
    }

    public TDSConnection getConnectionByName(String connectionName) {
        return this.namedConnections.get(connectionName);
    }

    public TDSConnection getConnectionByCaption(String caption) {
        for (TDSConnection con : this.namedConnections.values()) {
            if (!con.getCaption().equals(caption)) continue;
            return con;
        }
        return null;
    }
}

