/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.tds;

import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.model.tableau.tds.TDSModel;
import com.dbeaver.model.tableau.tds.TDSObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.w3c.dom.Element;

public class TDSRelation
extends TDSObject {
    public static final String TYPE_TEXT = "text";
    private final TDSModel tdsModel;
    private final Element relElement;
    private final boolean legacy;

    public TDSRelation(TDSModel tdsModel, Element relElement) {
        this(tdsModel, relElement, false);
    }

    public TDSRelation(TDSModel tdsModel, Element relElement, boolean legacy) {
        this.tdsModel = tdsModel;
        this.relElement = relElement;
        this.legacy = legacy;
    }

    public TDSModel getModel() {
        return this.tdsModel;
    }

    public TDSConnection getConnection() {
        return this.tdsModel.getConnectionByName(this.getConnectionId());
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    @Property(order=1)
    @NotNull
    public String getName() {
        return this.relElement.getAttribute("name");
    }

    @Property(order=2)
    public String getType() {
        return this.relElement.getAttribute("type");
    }

    public String getConnectionId() {
        return this.relElement.getAttribute("connection");
    }

    @Property(order=3, visibleIf=RelationTableValidator.class)
    public String getTable() {
        return this.relElement.getAttribute("table");
    }

    @Property(order=4, visibleIf=RelationQueryValidator.class)
    public String getCustomQueryText() {
        return this.relElement.getTextContent();
    }

    public void setCustomQueryText(String text) {
        this.relElement.setTextContent(text);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TDSRelation) {
            TDSRelation rel = (TDSRelation)obj;
            return this.getType().equals(rel.getType()) && this.getConnectionId().equals(rel.getConnectionId()) && this.getName().equals(rel.getName());
        }
        return false;
    }

    public boolean isCustomQL() {
        return TYPE_TEXT.equals(this.getType());
    }

    public static class RelationQueryValidator
    implements IPropertyValueValidator<TDSRelation, Object> {
        public boolean isValidValue(@NotNull TDSRelation object, @Nullable Object value) throws IllegalArgumentException {
            return object.getType().equals(TDSRelation.TYPE_TEXT);
        }
    }

    public static class RelationTableValidator
    implements IPropertyValueValidator<TDSRelation, Object> {
        public boolean isValidValue(@NotNull TDSRelation object, @Nullable Object value) throws IllegalArgumentException {
            return object.getType().equals("table");
        }
    }
}

