/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.upd.impl;

import com.dbeaver.jdbc.upd.protocol.UPDException;
import com.dbeaver.jdbc.upd.protocol.UPDObjectId;
import com.dbeaver.model.upd.impl.UPDServerObject;
import java.util.concurrent.atomic.AtomicLong;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.LongKeyMap;

public class UPDObjectManager {
    private static final Log log = Log.getLog(UPDObjectManager.class);
    private final LongKeyMap<UPDServerObject> allObjects = new LongKeyMap();
    private static final AtomicLong objectCounter = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateObject(UPDServerObject object) {
        LongKeyMap<UPDServerObject> longKeyMap = this.allObjects;
        synchronized (longKeyMap) {
            this.allObjects.put(object.getObjectId().getId(), (Object)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObject(UPDServerObject object) {
        LongKeyMap<UPDServerObject> longKeyMap = this.allObjects;
        synchronized (longKeyMap) {
            UPDServerObject so = (UPDServerObject)this.allObjects.remove(object.getObjectId().getId());
            if (so == null) {
                log.warn((Object)("Double close of object " + String.valueOf(object.getObjectId())));
            }
        }
    }

    @NotNull
    static UPDObjectId newObjectId() {
        long newId = objectCounter.incrementAndGet();
        return new UPDObjectId(newId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends UPDServerObject> T getObject(Class<T> theClass, UPDObjectId id) throws UPDException {
        LongKeyMap<UPDServerObject> longKeyMap = this.allObjects;
        synchronized (longKeyMap) {
            UPDServerObject object = (UPDServerObject)this.allObjects.get(id.getId());
            if (object == null) {
                throw new UPDException("Saved " + theClass.getSimpleName() + " '" + String.valueOf(id) + "' not found");
            }
            return (T)((UPDServerObject)theClass.cast(object));
        }
    }
}

