/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.upd.impl;

import com.dbeaver.jdbc.upd.protocol.UPDConnection;
import com.dbeaver.jdbc.upd.protocol.UPDException;
import com.dbeaver.jdbc.upd.protocol.UPDExecuteType;
import com.dbeaver.jdbc.upd.protocol.UPDExecutionResult;
import com.dbeaver.jdbc.upd.protocol.UPDObjectId;
import com.dbeaver.jdbc.upd.protocol.UPDProtocol;
import com.dbeaver.jdbc.upd.protocol.UPDResultSet;
import com.dbeaver.jdbc.upd.protocol.UPDSavepoint;
import com.dbeaver.jdbc.upd.protocol.UPDStatement;
import com.dbeaver.jdbc.upd.protocol.UPDStatementInput;
import com.dbeaver.jdbc.upd.protocol.meta.UPDDatabaseMetaData;
import com.dbeaver.model.upd.impl.UPDObjectManager;
import com.dbeaver.model.upd.impl.UPDServerConnection;
import com.dbeaver.model.upd.impl.UPDServerResultSet;
import com.dbeaver.model.upd.impl.UPDServerStatement;
import com.dbeaver.model.upd.impl.UPDServerUtils;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.utils.CommonUtils;

public abstract class UPDServerBase
extends UPDObjectManager
implements UPDProtocol {
    private static final Log log = Log.getLog(UPDServerBase.class);

    private UPDServerConnection getConnection(@NotNull UPDObjectId connectionId) throws UPDException {
        return this.getObject(UPDServerConnection.class, connectionId);
    }

    @NotNull
    public abstract UPDConnection openConnection(@NotNull Map<String, Object> var1, @NotNull Map<String, String> var2, @NotNull Map<String, String> var3) throws UPDException;

    @NotNull
    public DriverPropertyInfo[] readDriverProperties(@NotNull UPDObjectId connectionId) throws UPDException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.META, "Read driver properties");){
                DBPDataSourceContainer dsContainer = session.getDataSource().getContainer();
                DBPPropertyDescriptor[] properties = dsContainer.getDriver().getDataSourceProvider().getConnectionProperties(session.getProgressMonitor(), dsContainer.getDriver(), dsContainer.getConnectionConfiguration());
                return (DriverPropertyInfo[])Arrays.stream(properties).map(p -> {
                    IPropertyValueListProvider pvlp;
                    Object[] possibleValues;
                    DriverPropertyInfo pi = new DriverPropertyInfo(p.getDisplayName(), String.valueOf(p.getDefaultValue()));
                    pi.description = p.getDescription();
                    pi.required = p.isRequired();
                    if (p instanceof IPropertyValueListProvider && (possibleValues = (pvlp = (IPropertyValueListProvider)p).getPossibleValues(null)) != null) {
                        pi.choices = (String[])Arrays.stream(possibleValues).map(CommonUtils::toString).toArray(String[]::new);
                    }
                    return pi;
                }).toArray(DriverPropertyInfo[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new UPDException("Error getting driver property info", (Throwable)e);
        }
    }

    private DatabaseMetaData getConnectionMetaData(@NotNull UPDObjectId connectionId) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.META, "Read metadata");){
            return session.getMetaData();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public UPDDatabaseMetaData getDatabaseMetaData(@NotNull UPDObjectId connectionId) throws SQLException {
        return UPDDatabaseMetaData.createFrom((DatabaseMetaData)this.getConnectionMetaData(connectionId));
    }

    @NotNull
    public UPDResultSet readMetadataCatalogs(@NotNull UPDObjectId connectionId) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getCatalogs());
    }

    @NotNull
    public UPDResultSet readMetadataSchemas(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern) throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnectionMetaData(connectionId);
        ResultSet schemas = catalog == null && schemaPattern == null ? databaseMetaData.getSchemas() : databaseMetaData.getSchemas(catalog, schemaPattern);
        return UPDServerUtils.createFrom(schemas);
    }

    @NotNull
    public UPDResultSet readMetadataTableTypes(@NotNull UPDObjectId connectionId) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getTableTypes());
    }

    @NotNull
    public UPDResultSet readMetadataProcedures(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getProcedures(catalog, schemaPattern, procedureNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataProcedureColumns(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getProcedures(catalog, schemaPattern, procedureNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataFunctions(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getFunctions(catalog, schemaPattern, functionNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataFunctionColumns(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataTables(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getTables(catalog, schemaPattern, tableNamePattern, types));
    }

    @NotNull
    public UPDResultSet readMetadataTableColumns(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataTablePrivileges(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getTablePrivileges(catalog, schemaPattern, tableNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataTableColumnPrivileges(@NotNull UPDObjectId connectionId, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getColumnPrivileges(catalog, schema, table, columnNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataBestRowIdentifier(@NotNull UPDObjectId connectionId, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getBestRowIdentifier(catalog, schema, table, scope, nullable));
    }

    @NotNull
    public UPDResultSet readMetadataPseudoColumns(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataVersionColumns(@NotNull UPDObjectId connectionId, String catalog, String schema, String table) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getVersionColumns(catalog, schema, table));
    }

    @NotNull
    public UPDResultSet readMetadataPrimaryKeys(@NotNull UPDObjectId connectionId, String catalog, String schema, String table) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getPrimaryKeys(catalog, schema, table));
    }

    @NotNull
    public UPDResultSet readMetadataImportedKeys(@NotNull UPDObjectId connectionId, String catalog, String schema, String table) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getImportedKeys(catalog, schema, table));
    }

    @NotNull
    public UPDResultSet readMetadataExportedKeys(@NotNull UPDObjectId connectionId, String catalog, String schema, String table) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getExportedKeys(catalog, schema, table));
    }

    @NotNull
    public UPDResultSet readMetadataCrossReference(@NotNull UPDObjectId connectionId, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable));
    }

    @NotNull
    public UPDResultSet readMetadataTypeInfo(@NotNull UPDObjectId connectionId) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getTypeInfo());
    }

    @NotNull
    public UPDResultSet readMetadataIndexInfo(@NotNull UPDObjectId connectionId, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getIndexInfo(catalog, schema, table, unique, approximate));
    }

    @NotNull
    public UPDResultSet readMetadataUDTs(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getUDTs(catalog, schemaPattern, typeNamePattern, types));
    }

    @NotNull
    public UPDResultSet readMetadataAttributes(@NotNull UPDObjectId connectionId, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern));
    }

    @NotNull
    public UPDResultSet readMetadataClientInfoProperties(@NotNull UPDObjectId connectionId) throws SQLException {
        return UPDServerUtils.createFrom(this.getConnectionMetaData(connectionId).getClientInfoProperties());
    }

    public String connectionGetCatalog(@NotNull UPDObjectId connectionId) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Get catalog");){
            return session.getCatalog();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void connectionSetCatalog(@NotNull UPDObjectId connectionId, String catalog) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Set catalog");){
            session.setCatalog(catalog);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String connectionGetSchema(@NotNull UPDObjectId connectionId) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Get schema");){
            return session.getSchema();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void connectionSetSchema(@NotNull UPDObjectId connectionId, String schema) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Set schema");){
            session.setSchema(schema);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setAutoCommit(@NotNull UPDObjectId connectionId, boolean autoCommit) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Set auto commit");){
            session.setAutoCommit(autoCommit);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean getAutoCommit(@NotNull UPDObjectId connectionId) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Read metadata");){
            return session.getAutoCommit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void commitTransaction(@NotNull UPDObjectId connectionId) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Commit");){
            session.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void rollbackTransaction(@NotNull UPDObjectId connectionId, @Nullable UPDSavepoint savepoint) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = this.getConnection(connectionId).openSession(DBCExecutionPurpose.UTIL, "Rollback");){
            session.rollback();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void closeConnection(@NotNull UPDObjectId connectionId) throws UPDException {
        try {
            this.getConnection(connectionId).close();
        }
        catch (SQLException e) {
            throw new UPDException("Error closing connection", (Throwable)e);
        }
    }

    @NotNull
    public UPDStatement createStatement(@NotNull UPDObjectId connectionId, @NotNull UPDStatementInput parameters) throws UPDException {
        UPDServerConnection connection = this.getConnection(connectionId);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession dbCon = this.getConnection(connectionId).openSession(DBCExecutionPurpose.USER, "Create statement");){
                Object dbStat = parameters.getResultSetType() != null && parameters.getResultSetConcurrency() != null && parameters.getResultSetHoldability() != null ? dbCon.createStatement(parameters.getResultSetType().intValue(), parameters.getResultSetConcurrency().intValue(), parameters.getResultSetHoldability().intValue()) : (parameters.getResultSetType() != null && parameters.getResultSetConcurrency() != null ? dbCon.createStatement(parameters.getResultSetType().intValue(), parameters.getResultSetConcurrency().intValue()) : dbCon.createStatement());
                UPDServerStatement statement = new UPDServerStatement(this, connection, (Statement)dbStat);
                return statement.createProtocolObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new UPDException((Throwable)e);
        }
    }

    @NotNull
    public UPDStatement prepareStatement(@NotNull UPDObjectId connectionId, @NotNull UPDStatementInput parameters) throws UPDException {
        UPDServerConnection connection = this.getConnection(connectionId);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession dbCon = this.getConnection(connectionId).openSession(DBCExecutionPurpose.USER, "Create statement");){
                JDBCPreparedStatement dbStat = parameters.getAutoGeneratedColumnIndexes() != null ? dbCon.prepareStatement(parameters.getStatementText(), parameters.getAutoGeneratedColumnIndexes()) : (parameters.getAutoGeneratedColumnNames() != null ? dbCon.prepareStatement(parameters.getStatementText(), parameters.getAutoGeneratedColumnNames()) : (parameters.getAutoGeneratedKeys() != null ? dbCon.prepareStatement(parameters.getStatementText(), parameters.getAutoGeneratedKeys().intValue()) : (parameters.getResultSetType() != null && parameters.getResultSetConcurrency() != null && parameters.getResultSetHoldability() != null ? dbCon.prepareStatement(parameters.getStatementText(), parameters.getResultSetType().intValue(), parameters.getResultSetConcurrency().intValue(), parameters.getResultSetHoldability().intValue()) : (parameters.getResultSetType() != null && parameters.getResultSetConcurrency() != null ? dbCon.prepareStatement(parameters.getStatementText(), parameters.getResultSetType().intValue(), parameters.getResultSetConcurrency().intValue()) : dbCon.prepareStatement(parameters.getStatementText())))));
                UPDServerStatement statement = new UPDServerStatement(this, connection, (Statement)dbStat);
                return statement.createProtocolObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new UPDException((Throwable)e);
        }
    }

    @NotNull
    public UPDExecutionResult executeStatement(@NotNull UPDObjectId connectionId, @NotNull UPDObjectId statementId, @NotNull UPDExecuteType type, @NotNull UPDStatementInput input) throws UPDException {
        UPDServerConnection connection = this.getConnection(connectionId);
        UPDServerStatement statement = this.getObject(UPDServerStatement.class, statementId);
        UPDExecutionResult result = new UPDExecutionResult();
        Statement dbStat = statement.getStatement();
        try {
            if (dbStat instanceof PreparedStatement) {
                PreparedStatement ps = (PreparedStatement)dbStat;
                UPDServerUtils.setStatementParameters(ps, input);
            }
            switch (type) {
                case QUERY: {
                    ResultSet srcResultSet;
                    if (input.getStatementText() != null) {
                        srcResultSet = dbStat.executeQuery(input.getStatementText());
                    } else if (dbStat instanceof PreparedStatement) {
                        PreparedStatement preparedStatement = (PreparedStatement)dbStat;
                        srcResultSet = preparedStatement.executeQuery();
                    } else {
                        throw new UPDException("Do not know how to execute query in plain statement");
                    }
                    UPDServerResultSet serverResultSet = new UPDServerResultSet(this, connection, statement, input.isReadMetaData(), srcResultSet);
                    result.setResultSet(serverResultSet.createProtocolObject());
                    break;
                }
                case EXECUTE: {
                    boolean hasResultSet;
                    if (input.getStatementText() != null) {
                        hasResultSet = dbStat.execute(input.getStatementText());
                    } else if (dbStat instanceof PreparedStatement) {
                        PreparedStatement preparedStatement = (PreparedStatement)dbStat;
                        hasResultSet = preparedStatement.execute();
                    } else {
                        throw new UPDException("Do not know how to execute query in plain statement");
                    }
                    if (hasResultSet) {
                        ResultSet srcResultSet = dbStat.getResultSet();
                        UPDServerResultSet serverResultSet = new UPDServerResultSet(this, connection, statement, input.isReadMetaData(), srcResultSet);
                        result.setResultSet(serverResultSet.createProtocolObject());
                        break;
                    }
                    result.setUpdateCount(Long.valueOf(dbStat.getLargeUpdateCount()));
                    break;
                }
                case UPDATE: {
                    int updateCount;
                    if (input.getStatementText() != null) {
                        updateCount = dbStat.executeUpdate(input.getStatementText());
                    } else if (dbStat instanceof PreparedStatement) {
                        PreparedStatement preparedStatement = (PreparedStatement)dbStat;
                        updateCount = preparedStatement.executeUpdate();
                    } else {
                        throw new UPDException("Do not know how to execute update statement");
                    }
                    result.setUpdateCount(Long.valueOf(updateCount));
                    break;
                }
                case LARGE_UPDATE: {
                    long updateCount;
                    if (input.getStatementText() != null) {
                        updateCount = dbStat.executeLargeUpdate(input.getStatementText());
                    } else if (dbStat instanceof PreparedStatement) {
                        PreparedStatement preparedStatement = (PreparedStatement)dbStat;
                        updateCount = preparedStatement.executeLargeUpdate();
                    } else {
                        throw new UPDException("Do not know how to execute large update statement");
                    }
                    result.setUpdateCount(Long.valueOf(updateCount));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new UPDException("Error executing statement", (Throwable)e);
        }
        return result;
    }

    public void closeResultSet(@NotNull UPDObjectId connectionId, @NotNull UPDObjectId statementId, @NotNull UPDObjectId resultSetId) throws UPDException {
        try {
            UPDServerResultSet resultSet = this.getObject(UPDServerResultSet.class, resultSetId);
            resultSet.close();
        }
        catch (SQLException e) {
            log.error((Object)("Error closing result set: " + e.getMessage()));
        }
    }

    public void closeStatement(@NotNull UPDObjectId connectionId, @NotNull UPDObjectId statementId) throws UPDException {
        UPDServerStatement statement = this.getObject(UPDServerStatement.class, statementId);
        try {
            statement.close();
        }
        catch (SQLException e) {
            log.error((Object)"Error closing statement", (Throwable)e);
        }
    }

    public void cancelStatement(@NotNull UPDObjectId connectionId, @NotNull UPDObjectId statementId) throws UPDException {
        UPDServerStatement statement = this.getObject(UPDServerStatement.class, statementId);
        try {
            Statement jdbcStatement = statement.getStatement();
            if (jdbcStatement != null) {
                jdbcStatement.cancel();
            }
        }
        catch (SQLException e) {
            throw new UPDException("Statement cancel failed", (Throwable)e);
        }
    }

    public void close() {
    }
}

