/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.vault;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPAbstractParametersProvider;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.vault.VaultParametersProviderConfiguration;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.response.AuthResponse;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.oauth.code.OAuthCodeHandler;

public class VaultParametersProvider
extends DBPAbstractParametersProvider<VaultParametersProviderConfiguration> {
    private static final Log log = Log.getLog(VaultParametersProvider.class);
    public static final String VAULT_PROVIDER_ID = "vault-parameters-provider";
    private static final String VAULT_TOKEN_ATTRIBUTE = "vault-token-";

    @Nullable
    public Map<String, ?> readParameters(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor) throws DBException {
        DBPDatasourceExternalParameters datasourceParametersConfig = dataSourceDescriptor.getExternalParametersConfig();
        if (datasourceParametersConfig == null) {
            return null;
        }
        VaultParametersProviderConfiguration vaultProviderConfiguration = (VaultParametersProviderConfiguration)this.getConfiguration(datasourceParametersConfig, VaultParametersProviderConfiguration.class);
        VaultConfig vaultClientConfig = new VaultConfig().address(vaultProviderConfiguration.getVaultUrl());
        try {
            String vaultToken = this.resolveVaultToken(monitor, vaultClientConfig, vaultProviderConfiguration, dataSourceDescriptor);
            if (vaultToken == null) {
                throw new DBException("Vault token not resolved");
            }
            Vault vaultClient = Vault.create((VaultConfig)vaultClientConfig.token(vaultToken).build());
            LogicalResponse response = vaultClient.logical().read(datasourceParametersConfig.getSecretName());
            return response.getData();
        }
        catch (Exception e) {
            throw new DBException("Error reading Vault secret: " + e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    private String resolveVaultToken(@NotNull DBRProgressMonitor monitor, @NotNull VaultConfig vaultClientConfig, @NotNull VaultParametersProviderConfiguration vaultProviderConfiguration, @NotNull DataSourceDescriptorPRO dataSourceDescriptor) throws DBException, VaultException {
        if (vaultProviderConfiguration.getAuthType() == VaultParametersProviderConfiguration.AuthType.TOKEN) {
            return vaultProviderConfiguration.getToken();
        }
        SMSessionPersistent sessionPersistent = SMAuthUtils.findSessionPersistent((DBRProgressMonitor)monitor, (DBPProject)dataSourceDescriptor.getProject());
        if (sessionPersistent == null) {
            throw new DBException("No persistent session was found for " + dataSourceDescriptor.getProject().getDisplayName());
        }
        String vaultTokenSessionAttr = this.buildTokenAttributeKey(vaultProviderConfiguration);
        VaultTokenAdapter tokenAdapter = (VaultTokenAdapter)sessionPersistent.getAttribute(vaultTokenSessionAttr);
        if (tokenAdapter != null && !tokenAdapter.isExpired()) {
            return tokenAdapter.userToken;
        }
        Vault vaultClient = Vault.create((VaultConfig)vaultClientConfig.build());
        LocalDateTime tokenGenTime = LocalDateTime.now();
        AuthResponse authResponse = null;
        if (vaultProviderConfiguration.getAuthType() == VaultParametersProviderConfiguration.AuthType.USERNAME_PASSWORD) {
            if (CommonUtils.isEmpty((String)vaultProviderConfiguration.getUsername()) || CommonUtils.isEmpty((String)vaultProviderConfiguration.getPassword())) {
                throw new DBException("Vault username or password not found");
            }
            authResponse = vaultClient.auth().loginByUserPass(vaultProviderConfiguration.getUsername(), vaultProviderConfiguration.getPassword());
        } else if (vaultProviderConfiguration.getAuthType() == VaultParametersProviderConfiguration.AuthType.JWT || vaultProviderConfiguration.getAuthType() == VaultParametersProviderConfiguration.AuthType.OAUTH2) {
            Map userAttrs;
            String jwtToken = null;
            String vaultRole = null;
            jwtToken = CommonUtils.toString((Object)SMAuthUtils.findAuthAttribute((SMSession)sessionPersistent, (String)"jwt-token"));
            if (CommonUtils.isNotEmpty((String)vaultProviderConfiguration.getVaultRoleClaim()) && (userAttrs = (Map)SMAuthUtils.findAuthAttribute((SMSession)sessionPersistent, (String)"user.attributes")) != null) {
                vaultRole = CommonUtils.toString(userAttrs.get(vaultProviderConfiguration.getVaultRoleClaim()));
            }
            if (vaultProviderConfiguration.getAuthType() == VaultParametersProviderConfiguration.AuthType.OAUTH2) {
                if (CommonUtils.isEmpty((String)vaultProviderConfiguration.getSsoClientId()) || CommonUtils.isEmpty((String)vaultProviderConfiguration.getSsoAuthEndpointURL()) || CommonUtils.isEmpty((String)vaultProviderConfiguration.getSsoTokenEndpointURL())) {
                    throw new DBException("Invalid OAuth configuration");
                }
                try {
                    Map result = new OAuthCodeHandler(vaultProviderConfiguration.getSsoClientId(), vaultProviderConfiguration.getSsoClientSecret(), vaultProviderConfiguration.getSsoAuthEndpointURL(), vaultProviderConfiguration.getSsoTokenEndpointURL(), vaultProviderConfiguration.getSsoCallbackPort()).authorize();
                    jwtToken = (String)result.get("token");
                }
                catch (IOException e) {
                    throw new DBException("Error while getting auth token", (Throwable)e);
                }
            }
            if (CommonUtils.isEmpty((String)jwtToken)) {
                throw new DBException("JWT token not found for Vault authentication");
            }
            log.info((vaultRole = CommonUtils.nullIfEmpty(vaultRole)) == null ? "Default provider " : vaultRole + " role will be used for vault authentication in session " + sessionPersistent.getSessionId());
            authResponse = vaultClient.auth().loginByJwt(vaultProviderConfiguration.getVaultJwtProviderId(), CommonUtils.nullIfEmpty((String)vaultRole), jwtToken);
        }
        if (authResponse == null) {
            throw new DBException("Not authenticated in Vault");
        }
        String authClientToken = authResponse.getAuthClientToken();
        LocalDateTime tokenExpirationTime = tokenGenTime.plusSeconds(authResponse.getAuthLeaseDuration());
        sessionPersistent.setAttribute(vaultTokenSessionAttr, (Object)new VaultTokenAdapter(authClientToken, tokenExpirationTime));
        return authClientToken;
    }

    private String buildTokenAttributeKey(@NotNull VaultParametersProviderConfiguration vaultProviderConfiguration) {
        return VAULT_TOKEN_ATTRIBUTE + vaultProviderConfiguration.getConfigurationId();
    }

    public VaultParametersProviderConfiguration createDefaultConfiguration() {
        return new VaultParametersProviderConfiguration("");
    }

    public void invalidateCredentials(@NotNull SMSession session, @NotNull DBPParametersConfiguration configuration) throws DBException {
        super.invalidateCredentials(session, configuration);
        if (session instanceof SMSessionPersistent) {
            SMSessionPersistent sessionPersistent = (SMSessionPersistent)session;
            if (configuration instanceof VaultParametersProviderConfiguration) {
                VaultParametersProviderConfiguration vaultConfiguration = (VaultParametersProviderConfiguration)configuration;
                sessionPersistent.removeAttribute(this.buildTokenAttributeKey(vaultConfiguration));
            }
        }
    }

    private static class VaultTokenAdapter {
        @NotNull
        private final String userToken;
        @NotNull
        private final LocalDateTime expirationTime;

        private VaultTokenAdapter(@NotNull String userToken, @NotNull LocalDateTime expirationTime) {
            this.userToken = userToken;
            this.expirationTime = expirationTime;
        }

        boolean isExpired() {
            return LocalDateTime.now().isAfter(this.expirationTime);
        }
    }
}

