/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.vault;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class VaultParametersProviderConfiguration
extends DBPParametersConfiguration {
    @NotNull
    private AuthType authType = AuthType.TOKEN;
    @SecureProperty
    @Nullable
    private String token;
    @NotNull
    private String vaultUrl;
    @Nullable
    private String vaultJwtProviderId;
    @Nullable
    private String vaultRoleClaim;
    @SecureProperty
    @Nullable
    private String username;
    @SecureProperty
    @Nullable
    private String password;
    @Nullable
    private String ssoAuthEndpointURL;
    @Nullable
    private String ssoTokenEndpointURL;
    @Nullable
    private String ssoClientId;
    @SecureProperty
    @Nullable
    private String ssoClientSecret;
    private int ssoCallbackPort = 8000;
    @Nullable
    private Boolean globalConfiguration = null;

    public VaultParametersProviderConfiguration(@NotNull String configurationId) {
        super("vault-parameters-provider", configurationId);
    }

    @Property(required=true, order=1)
    @NotNull
    public String getVaultUrl() {
        return CommonUtils.trim((String)this.vaultUrl);
    }

    public void setVaultUrl(@NotNull String vaultUrl) {
        this.vaultUrl = CommonUtils.trim((String)vaultUrl);
    }

    @Property(required=true, order=2, listProvider=AuthTypeListProvider.class)
    @NotNull
    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        this.authType = authType;
        switch (authType) {
            case JWT: {
                this.token = null;
                this.username = null;
                this.password = null;
                break;
            }
            case TOKEN: {
                this.username = null;
                this.password = null;
                this.vaultRoleClaim = null;
                this.vaultJwtProviderId = null;
                break;
            }
            case USERNAME_PASSWORD: {
                this.token = null;
                this.vaultRoleClaim = null;
                this.vaultJwtProviderId = null;
            }
        }
    }

    @Property(order=3, hideExpr="object.authType != 'JWT'")
    @Nullable
    public String getVaultJwtProviderId() {
        return CommonUtils.trim((String)this.vaultJwtProviderId);
    }

    public void setVaultJwtProviderId(@Nullable String vaultJwtProviderId) {
        this.vaultJwtProviderId = CommonUtils.trim((String)vaultJwtProviderId);
    }

    @Property(order=4, hideExpr="object.authType != 'JWT'")
    @Nullable
    public String getVaultRoleClaim() {
        return CommonUtils.trim((String)this.vaultRoleClaim);
    }

    public void setVaultRoleClaim(@Nullable String vaultRoleClaim) {
        this.vaultRoleClaim = CommonUtils.trim((String)vaultRoleClaim);
    }

    @Property(password=true, order=5, hideExpr="object.authType != 'TOKEN'")
    @Nullable
    public String getToken() {
        return CommonUtils.trim((String)this.token);
    }

    public void setToken(@Nullable String vaultToken) {
        this.token = CommonUtils.trim((String)vaultToken);
    }

    @Property(order=6, hideExpr="object.authType != 'USERNAME_PASSWORD'")
    @Nullable
    public String getUsername() {
        return CommonUtils.trim((String)this.username);
    }

    public void setUsername(@Nullable String username) {
        this.username = CommonUtils.trim((String)username);
    }

    @Property(order=7, password=true, hideExpr="object.authType != 'USERNAME_PASSWORD'")
    @Nullable
    public String getPassword() {
        return CommonUtils.trim((String)this.password);
    }

    public void setPassword(@Nullable String password) {
        this.password = CommonUtils.trim((String)password);
    }

    @Nullable
    public String getSsoAuthEndpointURL() {
        return this.ssoAuthEndpointURL;
    }

    public void setSsoAuthEndpointURL(@Nullable String ssoAuthEndpointURL) {
        this.ssoAuthEndpointURL = ssoAuthEndpointURL;
    }

    @Nullable
    public String getSsoTokenEndpointURL() {
        return this.ssoTokenEndpointURL;
    }

    public void setSsoTokenEndpointURL(@Nullable String ssoTokenEndpointURL) {
        this.ssoTokenEndpointURL = ssoTokenEndpointURL;
    }

    @Nullable
    public String getSsoClientId() {
        return this.ssoClientId;
    }

    public void setSsoClientId(@Nullable String ssoClientId) {
        this.ssoClientId = ssoClientId;
    }

    @Nullable
    public String getSsoClientSecret() {
        return this.ssoClientSecret;
    }

    public void setSsoClientSecret(@Nullable String ssoClientSecret) {
        this.ssoClientSecret = ssoClientSecret;
    }

    public int getSsoCallbackPort() {
        return this.ssoCallbackPort;
    }

    public void setSsoCallbackPort(int ssoCallbackPort) {
        this.ssoCallbackPort = ssoCallbackPort;
    }

    @Property(order=8, requiredFeatures={"distributed"})
    public boolean isGlobalConfiguration() {
        return this.globalConfiguration == null || this.globalConfiguration != false || this.authType == AuthType.JWT;
    }

    public void setGlobalConfiguration(boolean isGlobal) {
        this.globalConfiguration = isGlobal;
    }

    public boolean valid() {
        boolean authValid = true;
        if (this.authType == AuthType.JWT && CommonUtils.isEmpty((String)this.getVaultJwtProviderId())) {
            authValid = false;
        } else if (this.authType == AuthType.TOKEN && CommonUtils.isEmpty((String)this.getToken())) {
            authValid = false;
        } else if (this.authType == AuthType.USERNAME_PASSWORD && (CommonUtils.isEmpty((String)this.getUsername()) || CommonUtils.isEmpty((String)this.getPassword()))) {
            authValid = false;
        } else if (this.authType == AuthType.OAUTH2 && CommonUtils.isEmpty((String)this.getVaultJwtProviderId()) && CommonUtils.isEmpty((String)this.getSsoClientId()) && CommonUtils.isEmpty((String)this.getSsoAuthEndpointURL()) && CommonUtils.isEmpty((String)this.getSsoTokenEndpointURL())) {
            authValid = false;
        }
        return CommonUtils.isNotEmpty((String)this.getVaultUrl()) && authValid && super.valid();
    }

    public static enum AuthType {
        JWT("JWT", DBWorkbench.getPlatform().getApplication().isMultiuser()),
        OAUTH2("OAuth2", !DBWorkbench.getPlatform().getApplication().isMultiuser()),
        TOKEN("Token", true),
        USERNAME_PASSWORD("Password", true);

        private final String name;
        private final boolean isShow;

        private AuthType(String name, boolean isShow) {
            this.name = name;
            this.isShow = isShow;
        }

        public String getName() {
            return this.name;
        }

        public boolean canShow() {
            return this.isShow;
        }
    }

    public static class AuthTypeListProvider
    implements IPropertyValueListProvider<VaultParametersProviderConfiguration> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(VaultParametersProviderConfiguration object) {
            ArrayList<AuthType> authTypes = new ArrayList<AuthType>();
            AuthType[] authTypeArray = AuthType.values();
            int n = authTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AuthType authType = authTypeArray[n2];
                if (authType.canShow()) {
                    authTypes.add(authType);
                }
                ++n2;
            }
            return authTypes.toArray();
        }
    }
}

