/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource;

import com.dbeaver.dpi.DPIController;
import com.dbeaver.dpi.DPIDataSourceParameters;
import com.dbeaver.dpi.DPIProcessController;
import com.dbeaver.dpi.DPIProvider;
import com.dbeaver.dpi.DPISession;
import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.dbeaver.model.datasource.parameters.DBPParametersUtils;
import com.dbeaver.model.internal.ModelMessages;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.qm.QMServiceProvider;
import com.dbeaver.model.security.SMConnectBruteForceValidator;
import com.dbeaver.model.security.SMControllerProvider;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceConnectErrorInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerBuffer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourcePersistentRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceDescriptorPRO
extends DataSourceDescriptor {
    private static final Log log = Log.getLog(DataSourceDescriptorPRO.class);
    @Nullable
    private DBPDatasourceExternalParameters externalParametersConfig;
    private transient DPIProcessController dpiController;
    private boolean dpiEnabled;

    public DataSourceDescriptorPRO(@NotNull DBPDataSourceRegistry registry, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        super(registry, id, driver, connectionInfo);
    }

    public DataSourceDescriptorPRO(@NotNull DBPDataSourceRegistry registry, @NotNull DBPDataSourceConfigurationStorage storage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        super(registry, storage, origin, id, driver, connectionInfo);
    }

    public DataSourceDescriptorPRO(@NotNull DBPDataSourceRegistry registry, @NotNull DBPDataSourceConfigurationStorage storage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver originalDriver, @NotNull DBPDriver substitutedDriver, @NotNull DBPConnectionConfiguration connectionInfo) {
        super(registry, storage, origin, id, originalDriver, substitutedDriver, connectionInfo);
    }

    public DataSourceDescriptorPRO(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry) {
        super(source, registry);
        if (source instanceof DataSourceDescriptorPRO) {
            DataSourceDescriptorPRO dsp = (DataSourceDescriptorPRO)source;
            if (dsp.externalParametersConfig != null) {
                this.externalParametersConfig = new DBPDatasourceExternalParameters(dsp.externalParametersConfig);
            }
        }
    }

    public DataSourceDescriptorPRO(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry, boolean setDefaultStorage) {
        super(source, registry, setDefaultStorage);
        if (source instanceof DataSourceDescriptorPRO) {
            DataSourceDescriptorPRO dsp = (DataSourceDescriptorPRO)source;
            if (dsp.externalParametersConfig != null) {
                this.externalParametersConfig = new DBPDatasourceExternalParameters(dsp.externalParametersConfig);
            }
        }
    }

    public boolean equalConfiguration(DataSourceDescriptor source) {
        if (super.equalConfiguration(source) && source instanceof DataSourceDescriptorPRO) {
            DataSourceDescriptorPRO dsp = (DataSourceDescriptorPRO)source;
            if (this.dpiEnabled == dsp.dpiEnabled && CommonUtils.equalObjects((Object)this.externalParametersConfig, (Object)dsp.externalParametersConfig)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public DBPDatasourceExternalParameters getExternalParametersConfig() {
        return this.externalParametersConfig;
    }

    public void setExternalParametersConfig(@Nullable DBPDatasourceExternalParameters externalParametersConfig) {
        this.externalParametersConfig = externalParametersConfig;
    }

    public boolean connect(@NotNull DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        long count;
        DBPApplicationEAP app;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP && (app = (DBPApplicationEAP)dBPApplication).isEarlyAccessProgram() && (count = this.getRegistry().getDataSources().stream().filter(Predicate.not(DBPDataSourceContainer::isHidden)).count()) > 3L) {
            throw new DBException(MessageFormat.format(ModelMessages.eap_connection_limit_exceeded_connect_message, 3));
        }
        this.validateConnectErrorAttempts();
        return super.connect(monitor, initialize, reflect);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleConnectError(@NotNull Throwable e) {
        void qsp;
        void connectException;
        super.handleConnectError(e);
        if (!DBWorkbench.getPlatform().getApplication().isMultiuser() && !DBWorkbench.isDistributed()) {
            return;
        }
        if (!(e instanceof DBCException)) {
            return;
        }
        DBCException dBCException = (DBCException)e;
        DBPDataSource dataSource = connectException.getDataSource();
        if (dataSource == null) {
            return;
        }
        DBPWorkspace dBPWorkspace = this.getProject().getWorkspace();
        if (!(dBPWorkspace instanceof QMServiceProvider)) {
            return;
        }
        QMServiceProvider qMServiceProvider = (QMServiceProvider)dBPWorkspace;
        QMService qmService = qsp.getActiveQueryManagerService();
        String qmSid = qsp.getQueryManagerSessionId();
        if (qmService == null || qmSid == null) {
            return;
        }
        QMMDataSourceConnectErrorInfo connectErrorInfo = new QMMDataSourceConnectErrorInfo(dataSource.getContainer(), DBExecUtils.discoverErrorType((DBPDataSource)dataSource, (Throwable)connectException).name(), CommonUtils.getRootCause((Throwable)connectException).getMessage());
        try {
            qmService.saveDataSourceConnectError(qmSid, connectErrorInfo);
        }
        catch (DBException ex) {
            log.error((Object)"Error saving data source connect error", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateConnectErrorAttempts() throws DBException {
        void validator;
        void smp;
        DBPWorkspace dBPWorkspace = this.getProject().getWorkspace();
        if (!(dBPWorkspace instanceof SMControllerProvider)) {
            return;
        }
        SMControllerProvider sMControllerProvider = (SMControllerProvider)dBPWorkspace;
        SMController smController = smp.getSecurityController();
        if (!(smController instanceof SMConnectBruteForceValidator)) {
            return;
        }
        SMConnectBruteForceValidator sMConnectBruteForceValidator = (SMConnectBruteForceValidator)smController;
        if (!validator.validateCurrentUserDataSourceConnectErrorAttempts(this.getProjectId(), this.getId())) {
            throw new DBException(ModelMessages.connection_brute_force_locked_message);
        }
    }

    protected void patchConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPConnectionConfiguration resolvedConnectionInfo) throws DBException {
        DBPParametersUtils.patchDataSourceConfiguration(monitor, this, resolvedConnectionInfo);
    }

    protected boolean closeConnectionDetached() {
        if (this.dpiController != null) {
            this.dpiController.close();
            this.dpiController = null;
            return true;
        }
        return false;
    }

    public void copyFrom(DataSourceDescriptor descriptor) {
        super.copyFrom(descriptor);
        if (descriptor instanceof DataSourceDescriptorPRO) {
            DataSourceDescriptorPRO dp = (DataSourceDescriptorPRO)descriptor;
            this.dpiEnabled = dp.dpiEnabled;
        }
    }

    @NotNull
    public DBPDataSourceContainer createCopy(DBPDataSourceRegistry forRegistry) {
        DataSourceDescriptorPRO copy = new DataSourceDescriptorPRO(this, forRegistry, true);
        copy.setId(DataSourceDescriptor.generateNewId((DBPDriver)copy.getDriver()));
        return copy;
    }

    public boolean isDetachedProcessEnabled() {
        return this.dpiEnabled;
    }

    public void setDetachedProcessEnabled(boolean enabled) {
        this.dpiEnabled = enabled;
    }

    @Nullable
    protected DBPDataSource openConnectionDetached(@NotNull DBRProgressMonitor monitor, boolean detachedProcess) {
        if (this.isDetachedProcessEnabled() && !detachedProcess) {
            return this.openDetachedConnection(monitor);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private DBPDataSource openDetachedConnection(@NotNull DBRProgressMonitor monitor) {
        try {
            void persistentRegistry;
            DPIProvider provider = (DPIProvider)GeneralUtils.adapt((Object)((Object)this), DPIProvider.class);
            if (provider == null) {
                throw new DBException("DPI provider not available");
            }
            this.dpiController = provider.detachDatabaseProcess(monitor, (DBPDataSourceContainer)this);
            LinkedHashMap credentials = new LinkedHashMap();
            DPIController dpiClient = this.dpiController.getClient();
            DPISession session = dpiClient.openSession();
            if (session == null) {
                throw new DBException("No session");
            }
            log.debug((Object)("New DPI session: " + session.getSessionId()));
            DBPDataSourceRegistry dBPDataSourceRegistry = this.getRegistry();
            if (!(dBPDataSourceRegistry instanceof DataSourcePersistentRegistry)) {
                throw new DBException("Illegal registry " + String.valueOf(this.getRegistry().getClass()));
            }
            DataSourcePersistentRegistry dataSourcePersistentRegistry = (DataSourcePersistentRegistry)dBPDataSourceRegistry;
            DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
            persistentRegistry.saveConfigurationToManager(monitor, (DataSourceConfigurationManager)buffer, dsc -> dsc.equals((Object)this));
            String[] driverLibraries = (String[])this.getDriver().getDriverLibraries().stream().map(DBPDriverLibrary::getLocalFile).filter(Objects::nonNull).map(path -> path.toAbsolutePath().toString()).toArray(String[]::new);
            DBPDataSource dataSource = dpiClient.openDataSource(new DPIDataSourceParameters(session.getSessionId(), buffer.getStringData(), driverLibraries, credentials));
            log.debug((Object)("Opened data source: " + String.valueOf(dataSource)));
            return dataSource;
        }
        catch (Exception e) {
            log.error((Object)"Error opening DPI process", (Throwable)e);
            this.closeConnectionDetached();
            return null;
        }
    }
}

