/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource;

import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.DataSourceSerializerModernPRO;
import com.dbeaver.model.internal.ModelMessages;
import java.text.MessageFormat;
import java.util.function.Predicate;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DataSourceRegistryPro
extends DataSourceRegistry<DataSourceDescriptorPRO> {
    public DataSourceRegistryPro(DBPProject project) {
        super(project);
    }

    public void addDataSource(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        long count;
        DBPApplicationEAP app;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP && (app = (DBPApplicationEAP)dBPApplication).isEarlyAccessProgram() && (count = this.getDataSources().stream().filter(Predicate.not(DBPDataSourceContainer::isHidden)).count()) >= 3L && !dataSource.isHidden()) {
            throw new DBException(MessageFormat.format(ModelMessages.eap_connection_limit_exceeded_creation_message, 3));
        }
        super.addDataSource(dataSource);
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptorPRO((DBPDataSourceRegistry)this, DataSourceDescriptor.generateNewId((DBPDriver)driver), driver, connConfig);
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(@NotNull DBPDataSourceContainer source) {
        DataSourceDescriptorPRO newDS = new DataSourceDescriptorPRO((DataSourceDescriptor)source, (DBPDataSourceRegistry)this);
        newDS.setId(DataSourceDescriptor.generateNewId((DBPDriver)source.getDriver()));
        return newDS;
    }

    public DBPDataSourceContainer createDataSource(DBPDataSourceConfigurationStorage dbpDataSourceConfigurationStorage, DBPDataSourceOrigin origin, String id, DriverDescriptor originalDriver, DriverDescriptor substitutedDriver, DBPConnectionConfiguration dbpConnectionConfiguration) {
        return new DataSourceDescriptorPRO((DBPDataSourceRegistry)this, dbpDataSourceConfigurationStorage, origin, id, (DBPDriver)originalDriver, (DBPDriver)substitutedDriver, dbpConnectionConfiguration);
    }

    public DBPDataSourceContainer createDataSource(@NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptorPRO((DBPDataSourceRegistry)this, id, driver, connConfig);
    }

    public DBPDataSourceContainer createDataSource(@NotNull DBPDataSourceConfigurationStorage dataSourceStorage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration configuration) {
        return new DataSourceDescriptorPRO((DBPDataSourceRegistry)this, dataSourceStorage, origin, id, driver, configuration);
    }

    @NotNull
    protected DataSourceSerializer<DataSourceDescriptorPRO> createModernSerializer() {
        return new DataSourceSerializerModernPRO(this);
    }
}

