/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.internal;

import com.dbeaver.jdbc.JdbcDriverInstanceProvider;
import java.sql.Driver;
import org.jkiss.api.CompositeObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

class RegistryDriverInstanceProvider
implements JdbcDriverInstanceProvider {
    private static final Log log = Log.getLog(RegistryDriverInstanceProvider.class);

    RegistryDriverInstanceProvider() {
    }

    @Nullable
    public Driver get(@NotNull CompositeObjectId ref) {
        DBPDriver driver = DataSourceProviderRegistry.getInstance().findDriver(ref);
        if (driver == null) {
            log.debug((Object)("Driver '" + String.valueOf(ref) + "' not found in the registry"));
            return null;
        }
        try {
            return (Driver)driver.getDefaultDriverLoader().getDriverInstance((DBRProgressMonitor)new LoggingProgressMonitor(log));
        }
        catch (DBException e) {
            throw new IllegalStateException("Error getting driver instance", e);
        }
    }
}

