/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net;

import com.dbeaver.model.net.ConfigurableNameService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.spi.InetAddressResolver;
import java.net.spi.InetAddressResolverProvider;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;

public class DynamicInetAddressResolver
implements InetAddressResolver {
    @NotNull
    private final InetAddressResolverProvider.Configuration configuration;

    public DynamicInetAddressResolver(@NotNull InetAddressResolverProvider.Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Stream<InetAddress> lookupByName(String host, InetAddressResolver.LookupPolicy lookupPolicy) throws UnknownHostException {
        InetAddress[] inetAddresses = ConfigurableNameService.INSTANCE.lookupAllHostAddr(host);
        if (inetAddresses != null) {
            return Arrays.stream(inetAddresses);
        }
        return this.configuration.builtinResolver().lookupByName(host, lookupPolicy);
    }

    @Override
    public String lookupByAddress(byte[] addr) throws UnknownHostException {
        String host = ConfigurableNameService.INSTANCE.getHostByAddr(addr);
        if (host != null) {
            return host;
        }
        return this.configuration.builtinResolver().lookupByAddress(addr);
    }
}

