/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net.k8s;

import com.dbeaver.model.net.k8s.K8SResourceType;
import com.dbeaver.model.net.k8s.KubeCtrlExecutor;
import com.dbeaver.model.net.k8s.comand.K8sCommand;
import com.dbeaver.model.net.k8s.comand.K8sCommandExecutionResult;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class K8SServiceInfo {
    private final DBWHandlerConfiguration configuration;
    private final List<K8sInfoItem> k8sInfoItems = new LinkedList<K8sInfoItem>();

    public List<K8sInfoItem> getK8sInfoItems() {
        return this.k8sInfoItems;
    }

    public DBWHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    K8SServiceInfo(DBWHandlerConfiguration configuration, List<K8sCommandExecutionResult> results) {
        this.configuration = configuration;
        for (K8sCommandExecutionResult result : results) {
            List<String> lines = Arrays.stream(result.stdOut().split("\\n")).filter(Predicate.not(String::isBlank)).map(String::trim).toList();
            for (String line : lines) {
                String[] items = line.split("\\s+");
                String svcName = items[0];
                int port = CommonUtils.isInt((Object)items[1]) ? Integer.parseInt(items[1]) : 0;
                ServicePortInfo portInfo = new ServicePortInfo(null, port, 0);
                if (CommonUtils.isEmpty((String)svcName)) continue;
                this.k8sInfoItems.add(new K8sInfoItem(svcName, portInfo, result.resourceType()));
            }
        }
    }

    public static K8SServiceInfo geResourceInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        K8sCommand getPods = new K8sCommand(K8SResourceType.POD, "get", "pods", "-o=custom-columns=:.metadata.name,:.spec.containers[0].ports[0].containerPort,:");
        K8sCommand getSvc = new K8sCommand(K8SResourceType.SERVICE, "get", "svc", "-o=custom-columns=:.metadata.name,:.spec.ports[0].port,:");
        K8sCommand getDeployments = new K8sCommand(K8SResourceType.DEPLOYMENT, "get", "deployments", "-o=custom-columns=:.metadata.name,:.spec.template.spec.containers[0].ports[0].containerPort,:");
        List<K8sCommandExecutionResult> k8sCommandExecutionResults = KubeCtrlExecutor.executeMultipleCommands(monitor, configuration, false, getPods, getSvc, getDeployments);
        return new K8SServiceInfo(configuration, k8sCommandExecutionResults);
    }

    public record K8sInfoItem(@NotNull String svcName, @NotNull ServicePortInfo portInfo, @NotNull K8SResourceType resourceType) {
    }

    public record ServicePortInfo(@Nullable String protocol, int port, int targetPor) {
    }
}

