/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.azure;

import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import com.dbeaver.net.auth.azure.AzureAuthType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelAzureAbstract<CREDENTIALS extends AuthModelAzureCredentials>
extends AuthModelDatabaseNative<CREDENTIALS> {
    public static final String AZURE_CLIENT_ID_PROP_LEGACY = "azureClientID";
    public static final String AZURE_TENANT_ID_PROP_LEGACY = "azureTenantID";
    public static final String AZURE_CLIENT_ID_PROP = "azure.client-id";
    public static final String AZURE_CLIENT_SECRET_PROP = "azure.client-secret";
    public static final String AZURE_CLIENT_CERTIFICATE_PATH_PROP = "azure.client-certificate-path";
    public static final String AZURE_CLIENT_CERTIFICATE_VALUE_PROP = "azure.client-certificate-value";
    public static final String AZURE_TENANT_ID_PROP = "azure.tenant-id";
    public static final String AZURE_AUTH_TYPE = "azure.auth-type";

    public static AuthModelAzureCredentials getAzureCredentialsFromContext(DBPConnectionConfiguration configuration) {
        return (AuthModelAzureCredentials)((Object)configuration.getRuntimeAttribute("azure.ad.credentials"));
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull CREDENTIALS credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        ((AuthModelAzureCredentials)((Object)credentials)).initTokenCache(dataSource.getContainer(), configuration);
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connectProps);
    }

    @NotNull
    public CREDENTIALS loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAzureCredentials credentials = (AuthModelAzureCredentials)super.loadCredentials(dataSource, configuration);
        AuthModelAzureAbstract.loadCredentialsFromMap(credentials, configuration.getAuthProperties());
        credentials.initTokenCache(dataSource, configuration);
        return (CREDENTIALS)((Object)credentials);
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull CREDENTIALS credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelAzureAbstract.saveCredentialsToMap(credentials, authProperties);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
    }

    public static void loadCredentialsFromMap(AuthModelAzureCredentials credentials, Map<String, String> authProperties) {
        if (authProperties == null) {
            return;
        }
        credentials.setAuthType((AzureAuthType)CommonUtils.valueOf(AzureAuthType.class, (String)authProperties.get(AZURE_AUTH_TYPE), (Enum)credentials.getAuthType()));
        credentials.setClientId((String)CommonUtils.notNull((Object)authProperties.get(AZURE_CLIENT_ID_PROP), (Object)authProperties.get(AZURE_CLIENT_ID_PROP_LEGACY)));
        credentials.setClientSecret(authProperties.get(AZURE_CLIENT_SECRET_PROP));
        credentials.setTenantId((String)CommonUtils.notNull((Object)authProperties.get(AZURE_TENANT_ID_PROP), (Object)authProperties.get(AZURE_TENANT_ID_PROP_LEGACY)));
        credentials.setClientCertificateValue(authProperties.get(AZURE_CLIENT_CERTIFICATE_VALUE_PROP));
        credentials.setClientCertificatePath(authProperties.get(AZURE_CLIENT_CERTIFICATE_PATH_PROP));
    }

    public static void saveCredentialsToMap(@NotNull AuthModelAzureCredentials credentials, Map<String, String> authProperties) {
        authProperties.put(AZURE_AUTH_TYPE, credentials.getAuthType().name());
        if (!CommonUtils.isEmpty((String)credentials.getClientId())) {
            authProperties.put(AZURE_CLIENT_ID_PROP, credentials.getClientId());
        } else {
            authProperties.remove(AZURE_CLIENT_ID_PROP);
        }
        if (!CommonUtils.isEmpty((String)credentials.getClientSecret())) {
            authProperties.put(AZURE_CLIENT_SECRET_PROP, credentials.getClientSecret());
        } else {
            authProperties.remove(AZURE_CLIENT_SECRET_PROP);
        }
        if (!CommonUtils.isEmpty((String)credentials.getTenantId())) {
            authProperties.put(AZURE_TENANT_ID_PROP, credentials.getTenantId());
        } else {
            authProperties.remove(AZURE_TENANT_ID_PROP);
        }
        if (!CommonUtils.isEmpty((String)credentials.getClientCertificateValue())) {
            authProperties.put(AZURE_CLIENT_CERTIFICATE_VALUE_PROP, credentials.getClientCertificateValue());
        } else {
            authProperties.remove(AZURE_CLIENT_CERTIFICATE_VALUE_PROP);
        }
        if (!CommonUtils.isEmpty((String)credentials.getClientCertificatePath())) {
            authProperties.put(AZURE_CLIENT_CERTIFICATE_PATH_PROP, credentials.getClientCertificatePath());
        } else {
            authProperties.remove(AZURE_CLIENT_CERTIFICATE_PATH_PROP);
        }
    }
}

