/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.net.auth.gcp.AuthModelGCPPreferences;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelGCPCredentials
extends AuthModelDatabaseNativeCredentials
implements SMSessionAuthCredentials {
    public static final String GCP_AUTH_CONTEXT_TYPE = "gcp";
    private static final Log log = Log.getLog(AuthModelGCPCredentials.class);
    private GCPAuthType authType;
    @SecureProperty
    private String clientId;
    @SecureProperty
    private String clientSecret;
    @SecureProperty
    private String refreshToken;
    private String serviceAccountConfigPath;
    private String serviceAccountConfig;
    private String projectId;
    private transient String token;
    private boolean ssoOverCli;
    private transient HttpTransport httpTransport;
    private final transient JsonFactory jsonFactory = new GsonFactory();
    private transient HttpCredentialsAdapter requestInitializer;

    public AuthModelGCPCredentials() {
    }

    public AuthModelGCPCredentials(AuthModelGCPCredentials source) {
        this.authType = source.authType;
        this.clientId = source.clientId;
        this.clientSecret = source.clientSecret;
        this.ssoOverCli = source.ssoOverCli;
        this.serviceAccountConfigPath = source.serviceAccountConfigPath;
        this.serviceAccountConfig = source.serviceAccountConfig;
        this.token = source.token;
        this.refreshToken = source.refreshToken;
        this.projectId = source.projectId;
    }

    public boolean isSessionCredentials() {
        return this.authType == GCPAuthType.SESSION_CREDENTIALS;
    }

    @Property(order=0x7FFFFFFC, listProvider=GCPAuthTypeValidValuesProvider.class, features={"large"})
    @AuthProperty(authContextType="gcp")
    @NotNull
    public GCPAuthType getAuthType() {
        return this.authType == null ? GCPAuthType.DEFAULT : this.authType;
    }

    public void setAuthType(GCPAuthType authType) {
        this.authType = authType;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30, hideExpr="object.authType != 'OAuth (Pregenerated)'")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Property(viewable=true, editable=true, updatable=true, order=31, password=true, hideExpr="object.authType != 'OAuth (Pregenerated)'")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Property(viewable=true, editable=true, updatable=true, order=32, password=true, hideExpr="object.authType != 'OAuth (Pregenerated)'")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getServiceAccountConfigPath() {
        return this.serviceAccountConfigPath;
    }

    public void setServiceAccountConfigPath(String serviceAccountConfigPath) {
        this.serviceAccountConfigPath = serviceAccountConfigPath;
    }

    @Property(features={"file"}, password=true, order=0x7FFFFFFD, hideExpr="object.authType != 'Key file'")
    public String getServiceAccountConfig() {
        return this.serviceAccountConfig;
    }

    public void setServiceAccountConfig(String serviceAccountConfig) {
        this.serviceAccountConfig = serviceAccountConfig;
    }

    public boolean isSsoOverCli() {
        return this.ssoOverCli;
    }

    public void setSsoOverCli(boolean ssoOverCli) {
        this.ssoOverCli = ssoOverCli;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public HttpTransport getTransport() {
        if (this.httpTransport == null) {
            this.httpTransport = new NetHttpTransport.Builder().build();
        }
        return this.httpTransport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public HttpRequestInitializer getRequestInitializer(@NotNull DBRProgressMonitor monitor) throws DBException {
        boolean reInitializeSSO;
        if (!monitor.isForceCacheUsage() && this.isSessionCredentials()) {
            this.resolveCredentials(monitor);
        }
        boolean bl = reInitializeSSO = this.ssoOverCli && CommonUtils.isEmpty((String)this.token) && !monitor.isForceCacheUsage();
        if (this.requestInitializer == null || reInitializeSSO) {
            if (reInitializeSSO) {
                this.initializeSSO(monitor);
            }
            this.requestInitializer = new HttpCredentialsAdapter(this.getGoogleCredentials());
        }
        return this.requestInitializer;
    }

    @NotNull
    public Credentials getGoogleCredentials() throws DBException {
        try {
            return switch (this.getAuthType()) {
                case GCPAuthType.DEFAULT -> GoogleCredentials.getApplicationDefault();
                case GCPAuthType.SERVICE_ACCOUNT -> {
                    if (!CommonUtils.isEmpty((String)this.serviceAccountConfigPath)) {
                        yield GoogleCredentials.fromStream((InputStream)Files.newInputStream(Path.of(this.serviceAccountConfigPath, new String[0]), new OpenOption[0]));
                    }
                    if (!CommonUtils.isEmpty((String)this.serviceAccountConfig)) {
                        yield AuthModelGCPCredentials.getServiceAccountCredentialsFromText(this.serviceAccountConfig);
                    }
                    throw new DBException("Empty service account credentials");
                }
                case GCPAuthType.SSO_OVER_CLI, GCPAuthType.SESSION_CREDENTIALS -> {
                    if (CommonUtils.isNotEmpty((String)this.token)) {
                        yield GoogleCredentials.create((AccessToken)new AccessToken(this.token, null));
                    }
                    yield GoogleCredentials.getApplicationDefault();
                }
                case GCPAuthType.PREGENERATED_OAUTH -> {
                    if (CommonUtils.isEmpty((String)this.clientId) || CommonUtils.isEmpty((String)this.clientSecret) || CommonUtils.isEmpty((String)this.refreshToken)) {
                        throw new DBException("Client ID/Secret/Refresh token must be provided for auth");
                    }
                    UserCredentials creds = UserCredentials.newBuilder().setClientId(this.clientId).setClientSecret(this.clientSecret).setRefreshToken(this.refreshToken).build();
                    if (CommonUtils.isNotEmpty((String)this.projectId)) {
                        creds = creds.createWithQuotaProject(this.projectId);
                    }
                    yield creds;
                }
                default -> throw new MatchException(null, null);
            };
        }
        catch (Exception e) {
            throw new DBException("Error configuring Google credentials", (Throwable)e);
        }
    }

    private boolean initializeConnection(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.ssoOverCli) {
            this.initializeSSO(monitor);
            return true;
        }
        return false;
    }

    private void initializeSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize login over GCP CLI");
        String cliPrintAccessToken = this.getGCPExecutablePath("auth print-access-token");
        String accessTokenResponse = this.executeCLI(monitor, cliPrintAccessToken, true, true);
        if (CommonUtils.isNotEmpty((String)accessTokenResponse) && accessTokenResponse.startsWith("ya29.")) {
            this.token = accessTokenResponse;
            return;
        }
        String cliParams = this.getGCPExecutablePath("auth login");
        log.debug((Object)("Perform GCP SSO init [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams, false, false);
        String tokenFromCli = this.executeCLI(monitor, cliPrintAccessToken, true, false);
        if (CommonUtils.isNotEmpty((String)tokenFromCli)) {
            this.token = tokenFromCli;
        }
        monitor.subTask("SSO init finished");
    }

    private void logoutSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Revoke credentials over GCP CLI");
        String cliParams = this.getGCPExecutablePath("auth revoke");
        log.debug((Object)("Perform GCP SSO logout [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams, false, false);
        monitor.subTask("SSO logout finished");
    }

    @NotNull
    private String getGCPExecutablePath(String params) {
        String executable = AuthModelGCPPreferences.getPreferences().getString("gcp.cli.executable");
        return (String)(CommonUtils.isEmpty((String)executable) ? (RuntimeUtils.isWindows() ? "cmd /c " : "") + "gcloud" : executable) + " " + params;
    }

    private String executeCLI(@NotNull DBRProgressMonitor monitor, String cliParams, boolean needOutputResult, boolean canSkipError) throws DBCException {
        DBRShellCommand cliCommand = new DBRShellCommand(cliParams);
        cliCommand.setEnabled(true);
        final DBRProcessDescriptor cliProcess = new DBRProcessDescriptor(cliCommand);
        try {
            cliProcess.execute();
        }
        catch (DBException e) {
            throw new DBCException("Error running GCP CLI. Is it installed on the local machine?", (Throwable)e);
        }
        final String[] cliErrorLog = new String[2];
        AbstractJob dumpJob = null;
        if (cliProcess.isRunning()) {
            dumpJob = new AbstractJob(cliProcess.getName() + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        cliErrorLog[0] = cliProcess.dumpErrors();
                        cliErrorLog[1] = cliProcess.dumpOutput();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            dumpJob.schedule();
        }
        while (cliProcess.isRunning()) {
            if (monitor.isCanceled()) {
                cliProcess.terminate();
                throw new DBCException("GCP SSO initialization has been canceled");
            }
            RuntimeUtils.pause((int)50);
        }
        if (dumpJob != null) {
            try {
                dumpJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        int resCode = cliProcess.getUpdatedExitValueCode();
        String message = cliErrorLog[0];
        String output = cliErrorLog[1];
        if (!canSkipError && resCode != 0) {
            if (!CommonUtils.isEmptyTrimmed((String)message)) {
                log.debug((Object)("GCP SSO connection error message:\n" + message));
                throw new DBCException(message);
            }
            log.debug((Object)("GCP SSO login ended with result  code " + resCode));
        }
        if (!CommonUtils.isEmptyTrimmed((String)message)) {
            log.debug((Object)("GCP SSO login info message:\n" + message));
        }
        if (needOutputResult && !CommonUtils.isEmptyTrimmed((String)output)) {
            return output.trim();
        }
        return null;
    }

    public boolean refreshSession(DBRProgressMonitor monitor) throws DBException {
        if (this.isSessionCredentials()) {
            SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)GCP_AUTH_CONTEXT_TYPE, (String)"Google", (SMSessionAuthCredentials)this);
            return true;
        }
        if (!this.ssoOverCli) {
            return false;
        }
        this.initializeSSO(monitor);
        return true;
    }

    public boolean closeSession(DBRProgressMonitor monitor) throws DBCException {
        if (!this.ssoOverCli) {
            return false;
        }
        this.logoutSSO(monitor);
        this.token = null;
        return true;
    }

    public void resetCache() {
        this.httpTransport = null;
        this.requestInitializer = null;
    }

    public String getUserIdentity(DBRProgressMonitor monitor) {
        Credentials credentials;
        if (this.ssoOverCli && this.token != null) {
            String[] jwtToken;
            block5: {
                String gcloudExec = this.getGCPExecutablePath("auth print-identity-token");
                try {
                    String identityTokenResponse = this.executeCLI(monitor, gcloudExec, true, true);
                    jwtToken = this.parseJwtToken(identityTokenResponse);
                    if (jwtToken != null) break block5;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            Map map = JSONUtils.parseMap((Gson)new Gson(), (Reader)new StringReader(jwtToken[1]));
            return CommonUtils.toString(map.get("email"), null);
        }
        if (this.requestInitializer != null && (credentials = this.requestInitializer.getCredentials()) instanceof ServiceAccountCredentials) {
            return ((ServiceAccountCredentials)credentials).getClientEmail();
        }
        return null;
    }

    private String[] parseJwtToken(String tokenEncoded) {
        if (tokenEncoded == null) {
            return null;
        }
        String[] chunks = tokenEncoded.split("\\.");
        if (chunks.length < 2) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        String header = new String(decoder.decode(chunks[0]));
        String payload = new String(decoder.decode(chunks[1]));
        return new String[]{header, payload};
    }

    public void resolveCredentials(DBRProgressMonitor monitor) throws DBException {
        switch (this.getAuthType()) {
            case SESSION_CREDENTIALS: {
                if (!CommonUtils.isEmpty((String)this.token)) {
                    return;
                }
                if (SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)GCP_AUTH_CONTEXT_TYPE, (String)"Google", (SMSessionAuthCredentials)this)) break;
                throw new DBCException("Google session credentials are missing");
            }
            case SSO_OVER_CLI: {
                this.initializeConnection(monitor);
            }
        }
    }

    public static GoogleCredentials getServiceAccountCredentialsFromText(@NotNull String text) throws DBException {
        try {
            text = new String(Base64.getDecoder().decode(text));
        }
        catch (Exception exception) {}
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream cfgFileStream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
                return GoogleCredentials.fromStream((InputStream)cfgFileStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error resolving credentials from stream", (Throwable)e);
        }
    }

    public static class GCPAuthTypeValidValuesProvider
    implements IPropertyValueListProvider<AuthModelGCPCredentials> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(AuthModelGCPCredentials credentials) {
            if (!DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                return GCPAuthType.values();
            }
            return Arrays.stream(GCPAuthType.values()).filter(authType -> !authType.isDesktop()).toArray();
        }
    }
}

