/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.krb5;

import com.dbeaver.net.auth.krb5.AuthModelKerberosCredentials;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelKerberos
extends AuthModelDatabaseNative<AuthModelKerberosCredentials> {
    private static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    private static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final String JAVA_SECURITY_KRB5_REALM = "java.security.krb5.realm";
    private static final String JAVA_SECURITY_KRB5_KDC = "java.security.krb5.kdc";
    private static final String JAVA_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final String JAVA_SECURITY_JGSS_DEBUG = "sun.security.jgss.debug";
    private static final String JAVA_SECURITY_AUTH_USESUBJECTCREDSONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final Log log = Log.getLog(AuthModelKerberos.class);

    @NotNull
    public AuthModelKerberosCredentials createCredentials() {
        return new AuthModelKerberosCredentials();
    }

    @NotNull
    public AuthModelKerberosCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        Object krbUserName;
        AuthModelKerberosCredentials credentials = (AuthModelKerberosCredentials)super.loadCredentials(dataSource, configuration);
        String realmName = CommonUtils.toString((Object)configuration.getAuthProperty("krb5.realm"));
        credentials.setKdcServer(CommonUtils.toString((Object)configuration.getAuthProperty("krb5.kdc_server")));
        credentials.setKrbUserName(CommonUtils.toString((Object)configuration.getAuthProperty("krb5.user")));
        if (CommonUtils.isEmpty((String)credentials.getKrbUserName())) {
            credentials.setKrbUserName(configuration.getUserName());
        }
        if (CommonUtils.isEmpty((String)configuration.getUserName())) {
            credentials.setUserName(credentials.getKrbUserName());
        }
        if (!CommonUtils.isEmpty((String)(krbUserName = credentials.getKrbUserName()))) {
            String userName = credentials.getUserName();
            if (CommonUtils.isEmpty((String)realmName)) {
                if (((String)krbUserName).contains("@")) {
                    realmName = ((String)krbUserName).substring(((String)krbUserName).lastIndexOf(64) + 1);
                } else if (userName.contains("@")) {
                    realmName = userName.substring(userName.lastIndexOf(64) + 1);
                }
            } else if (!((String)krbUserName).contains("@")) {
                krbUserName = (String)krbUserName + "@" + realmName;
                credentials.setKrbUserName((String)krbUserName);
            }
        }
        credentials.setKrbRealmName(realmName);
        credentials.setUseKeytab(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.use_keytab"), (boolean)Boolean.FALSE));
        credentials.setForceTcp(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.kdc_over_tcp"), (boolean)Boolean.FALSE));
        credentials.setKeytabPath(GeneralUtils.replaceVariables((String)CommonUtils.toString((Object)configuration.getAuthProperty("krb5.keytab_path")), (IVariableResolver)new DataSourceVariableResolver(dataSource, configuration)));
        credentials.setUseKinit(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.use_kinit"), (boolean)Boolean.FALSE));
        credentials.setCacheFilePath(configuration.getAuthProperty("krb5.kinit_cache_file"));
        credentials.setKrb5ConfPath(configuration.getAuthProperty("krb5.conf.path"));
        credentials.setServiceName(configuration.getAuthProperty("SERVICE_NAME"));
        credentials.setUseSslJks(CommonUtils.getBoolean((String)configuration.getAuthProperty("USE_SSL_JKS"), (boolean)Boolean.FALSE));
        credentials.setSslJksPath(configuration.getAuthProperty("SSL_JKS_PATH"));
        credentials.setSslJksPassword(configuration.getAuthProperty("SSL_JKS_PASSWORD"));
        credentials.setShowDebugInfo(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.debug")));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelKerberosCredentials credentials) {
        configuration.setAuthProperty("krb5.kdc_server", credentials.getKdcServer());
        configuration.setAuthProperty("krb5.user", credentials.getKrbUserName());
        configuration.setAuthProperty("krb5.realm", credentials.getKrbRealmName());
        configuration.setAuthProperty("krb5.use_keytab", String.valueOf(credentials.isUseKeytab()));
        configuration.setAuthProperty("krb5.kdc_over_tcp", String.valueOf(credentials.isForceTcp()));
        configuration.setAuthProperty("krb5.keytab_path", credentials.getKeytabPath());
        configuration.setAuthProperty("krb5.use_kinit", String.valueOf(credentials.isUseKinit()));
        configuration.setAuthProperty("krb5.kinit_cache_file", credentials.getCacheFilePath());
        configuration.setAuthProperty("krb5.conf.path", credentials.getKrb5ConfPath());
        configuration.setAuthProperty("SERVICE_NAME", credentials.getServiceName());
        configuration.setAuthProperty("USE_SSL_JKS", String.valueOf(credentials.isUseSslJks()));
        configuration.setAuthProperty("SSL_JKS_PATH", credentials.getSslJksPath());
        configuration.setAuthProperty("SSL_JKS_PASSWORD", credentials.getSslJksPassword());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelKerberosCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        try {
            this.initKerberos(monitor, dataSource, credentials);
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    protected boolean isUserNameNeeded(@NotNull DBPDataSource dataSource) {
        return CommonUtils.getBoolean((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.sendUserNameToDatabase"), (boolean)true);
    }

    protected boolean isUserPasswordNeeded(@NotNull DBPDataSource dataSource) {
        return CommonUtils.getBoolean((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.sendPasswordToDatabase"), (boolean)true);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        System.clearProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
        System.clearProperty(JAVA_SECURITY_KRB5_REALM);
        System.clearProperty(JAVA_SECURITY_KRB5_KDC);
        System.clearProperty(JAVA_SECURITY_KRB5_CONF);
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    private void initKerberos(DBRProgressMonitor monitor, DBPDataSource dataSource, AuthModelKerberosCredentials credentials) throws IOException, DBCException {
        String keytabPath;
        boolean useAuthSubject = this.isUseAuthSubject(dataSource.getContainer());
        boolean credsOptional = credentials.isUseKinit();
        if (CommonUtils.isEmpty((String)credentials.getKrbUserName()) && !credsOptional) {
            throw new DBCException("Can't determine Kerberos user");
        }
        if (CommonUtils.isEmpty((String)credentials.getKrbRealmName()) && !credsOptional) {
            throw new DBCException("Realm must be specified or provided with Kerberos username");
        }
        monitor.subTask("Initialize Kerberos configuration");
        String username = credentials.getUserName();
        File ticketCacheFile = null;
        Path tempDir = DBWorkbench.getPlatform().getTempFolder(monitor, "krb5");
        if (!credentials.isUseKinit()) {
            Path credentialCacheFile = Files.createTempFile(tempDir, "krb5-", ".ccache", new FileAttribute[0]);
            credentialCacheFile.toFile().deleteOnExit();
            ticketCacheFile = credentialCacheFile.toFile();
        } else if (!CommonUtils.isEmpty((String)credentials.getCacheFilePath())) {
            ticketCacheFile = new File(credentials.getCacheFilePath());
        }
        if (CommonUtils.isEmpty((String)username) && !credsOptional) {
            throw new DBCException("Empty user name");
        }
        String realm = credentials.getKrbRealmName();
        String kdcServer = credentials.getKdcServer();
        Object krb5User = credentials.getKrbUserName();
        if (CommonUtils.isEmpty((String)krb5User)) {
            krb5User = username;
        }
        if (CommonUtils.isEmpty((String)realm)) {
            if (!CommonUtils.isEmpty((String)krb5User) && ((String)krb5User).contains("@")) {
                realm = ((String)krb5User).substring(((String)krb5User).lastIndexOf(64) + 1);
            } else if (!CommonUtils.isEmpty((String)username) && username.contains("@")) {
                realm = username.substring(username.lastIndexOf(64) + 1);
            } else if (!credsOptional) {
                throw new DBCException("Realm must be specified or provided with Kerberos username");
            }
        } else if (!CommonUtils.isEmpty((String)krb5User) && !((String)krb5User).contains("@")) {
            krb5User = username + "@" + realm;
        }
        if (!CommonUtils.isEmpty((String)kdcServer)) {
            System.setProperty(JAVA_SECURITY_KRB5_KDC, kdcServer);
        } else if (!credsOptional) {
            throw new DBCException("KDC Server must be specified");
        }
        if (!CommonUtils.isEmpty((String)realm)) {
            System.setProperty(JAVA_SECURITY_KRB5_REALM, realm);
        }
        String string = keytabPath = credentials.isUseKeytab() ? credentials.getKeytabPath() : null;
        if (credentials.isUseKeytab() && CommonUtils.isEmpty((String)keytabPath)) {
            throw new DBCException("Keytab must be provided.");
        }
        if (credentials.isShowDebugInfo()) {
            System.setProperty(JAVA_SECURITY_KRB5_DEBUG, "true");
            System.setProperty(JAVA_SECURITY_JGSS_DEBUG, "true");
        }
        System.setProperty(JAVA_SECURITY_AUTH_USESUBJECTCREDSONLY, String.valueOf(false));
        if (credentials.isShowDebugInfo()) {
            log.debug((Object)"KRB5: Setting kerberos properties");
        }
        if (!CommonUtils.isEmpty((String)credentials.getKrb5ConfPath())) {
            System.setProperty(JAVA_SECURITY_KRB5_CONF, credentials.getKrb5ConfPath());
        }
        if (!credentials.isUseKinit()) {
            this.callKinit(credentials, ticketCacheFile);
        }
        if (!useAuthSubject) {
            Path jaasFile = this.createJaasFile(tempDir, dataSource, credentials, ticketCacheFile, (String)krb5User, realm);
            jaasFile.toFile().deleteOnExit();
            String jaasConfigPath = jaasFile.toAbsolutePath().toString();
            System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, jaasConfigPath);
            Configuration config = Configuration.getConfiguration();
            config.refresh();
        } else {
            Subject subject = this.authenticateSubject(dataSource, credentials, ticketCacheFile, (String)krb5User, realm);
            credentials.setAuthSubject(subject);
        }
        CommonUtils.isEmpty((String)credentials.getCacheFilePath());
    }

    protected boolean isUseAuthSubject(@NotNull DBPDataSourceContainer dataSource) {
        return false;
    }

    private void callKinit(AuthModelKerberosCredentials credentials, File ticketCacheFile) throws DBCException {
        KrbClient client = null;
        try {
            if (credentials.getKrb5ConfPath() != null) {
                KrbConfig config = new KrbConfig();
                File configFile = new File(credentials.getKrb5ConfPath());
                if (configFile.exists()) {
                    config.addKrb5Config(configFile);
                }
                client = new KrbClient(config);
            }
            if (client == null) {
                client = new KrbClient();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Kerberos config was ignored, using empty config", (Throwable)e);
            client = new KrbClient(new KrbConfig());
        }
        try {
            client.setKdcRealm(credentials.getKrbRealmName());
            client.setKdcHost(credentials.getKdcServer());
            if (credentials.isForceTcp()) {
                client.setAllowUdp(false);
                client.setAllowTcp(true);
            }
            client.init();
            TgtTicket tgt = credentials.isUseKeytab() ? client.requestTgt(credentials.getKrbUserName(), new File(credentials.getKeytabPath())) : client.requestTgt(credentials.getKrbUserName(), CommonUtils.notEmpty((String)credentials.getUserPassword()));
            client.storeTicket(tgt, ticketCacheFile);
        }
        catch (KrbException e) {
            throw new DBCException("KerberosException", (Throwable)e);
        }
    }

    private Path createJaasFile(Path tempDir, DBPDataSource dataSource, AuthModelKerberosCredentials credentials, File ticketCacheFile, String krb5User, String realm) throws IOException {
        boolean krb5Debug = credentials.isShowDebugInfo();
        String loginModuleName = this.getLoginModuleName(dataSource, credentials);
        Path jaasFile = Files.createTempFile(tempDir, "jaas-", ".conf", new FileAttribute[0]);
        Throwable throwable = null;
        Object var11_12 = null;
        try (BufferedWriter fw = Files.newBufferedWriter(jaasFile, new OpenOption[0]);){
            fw.write(loginModuleName);
            fw.write(" {\n");
            fw.write("  com.sun.security.auth.module.Krb5LoginModule required\n");
            fw.write("  doNotPrompt=true\n");
            fw.write("  useTicketCache=true\n");
            fw.write("  refreshKrb5Config=true\n");
            fw.write("  renewTGT=true\n");
            if (!CommonUtils.isEmpty((String)krb5User)) {
                fw.write(String.format("  principal=\"%s\"\n", krb5User));
            }
            if (!CommonUtils.isEmpty((String)realm)) {
                fw.write(String.format("  realm=\"%s\"\n", realm));
            }
            if (ticketCacheFile != null) {
                fw.write(String.format("  ticketCache=\"%s\"\n", ticketCacheFile.getAbsolutePath().replace("\\", "/")));
            }
            fw.write("  debug=" + krb5Debug + ";\n");
            fw.write("};\n");
            ((Writer)fw).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return jaasFile;
    }

    private Subject authenticateSubject(DBPDataSource dataSource, AuthModelKerberosCredentials credentials, File ticketCacheFile, String krb5User, String realm) throws IOException {
        boolean retLogin;
        Krb5LoginModule krb5Module = new Krb5LoginModule();
        HashMap sharedState = new HashMap();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (credentials.isShowDebugInfo()) {
            options.put("debug", "true");
        }
        options.put("doNotPrompt", "true");
        options.put("useTicketCache", "true");
        options.put("refreshKrb5Config", "true");
        if (ticketCacheFile != null) {
            options.put("ticketCache", ticketCacheFile.getAbsolutePath().replace("\\", "/"));
        }
        if (!CommonUtils.isEmpty((String)krb5User) && !CommonUtils.isEmpty((String)realm)) {
            options.put("principal", krb5User + "@" + realm);
        }
        Subject specificSubject = new Subject();
        krb5Module.initialize(specificSubject, null, sharedState, options);
        try {
            retLogin = krb5Module.login();
            krb5Module.commit();
        }
        catch (LoginException loginException) {
            throw new IOException("Kerberos adaptor couldn't retrieve credentials (TGT) from the cache");
        }
        if (!retLogin) {
            throw new IOException("Kerberos adaptor couldn't retrieve credentials (TGT) from the cache");
        }
        return specificSubject;
    }

    protected String getLoginModuleName(DBPDataSource dataSource, AuthModelKerberosCredentials credentials) {
        return CommonUtils.toString((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.loginModule"), (String)"Krb5ConnectorContext");
    }
}

