/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat;

import com.dbeaver.model.ai.AIChatAnnotation;
import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.ui.ai.chat.AIChatController;
import com.dbeaver.ui.ai.chat.AIChatViewHandler;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.registry.AISettingsEventListener;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;

public class AIChatView
extends ViewPart {
    private static final Log log = Log.getLog(AIChatView.class);
    public static final String VIEW_ID = "com.dbeaver.ai.chat";
    public static final String CONTEXT_ID = "com.dbeaver.ai.chat";
    private AIChatControl chat;
    private AIChatViewHandler handler;
    private DBPPreferenceListener preferenceListener;
    private AISettingsEventListener aiSettingsEventListener;

    public void createPartControl(Composite parent) {
        AIContextSettings settings;
        this.chat = new AIChatControl(parent, new ViewController());
        this.handler = new AIChatViewHandler(this);
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        if (service != null) {
            service.activateContext("com.dbeaver.ai.chat");
        }
        if ((settings = this.chat.getCompletionSettings()) != null && settings.getDataSourceContainer() != null) {
            DBPDataSourceContainer container = settings.getDataSourceContainer();
            AIProFeatures.AI_CHAT.use(AIProFeatures.buildFeatureParameters(container));
        }
        this.preferenceListener = event -> UIUtils.asyncExec(() -> {
            if ("ai.chat.webRenderer".equals(event.getProperty())) {
                try {
                    this.hide();
                    AIChatView.show();
                }
                catch (DBException e) {
                    log.error((Object)"Error reopening AI chat view", (Throwable)e);
                }
            }
        });
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
        this.aiSettingsEventListener = registry -> {
            if (registry.getSettings().isAiDisabled()) {
                this.hide();
            }
        };
        AISettingsManager.getInstance().addChangedListener(this.aiSettingsEventListener);
    }

    public void setFocus() {
        this.chat.setFocusOnPrompt();
    }

    public void dispose() {
        super.dispose();
        if (this.handler != null) {
            this.handler.dispose();
        }
        if (this.preferenceListener != null) {
            DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
            this.preferenceListener = null;
        }
        if (this.aiSettingsEventListener != null) {
            AISettingsManager.getInstance().removeChangedListener(this.aiSettingsEventListener);
            this.aiSettingsEventListener = null;
        }
    }

    @NotNull
    public static AIChatView show() throws DBException {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewPart view = UIUtils.findView((IWorkbenchWindow)window, (String)"com.dbeaver.ai.chat");
        if (view != null) {
            page.bringToTop((IWorkbenchPart)view);
            return (AIChatView)view;
        }
        try {
            return (AIChatView)page.showView("com.dbeaver.ai.chat");
        }
        catch (PartInitException e) {
            throw new DBException("Can't open AI chat view", (Throwable)e);
        }
    }

    public void hide() {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        page.hideView((IViewPart)this);
    }

    @NotNull
    public AIChatControl getChat() {
        return this.chat;
    }

    private void findOrOpenEditor(@NotNull Consumer<SQLEditor> consumer) {
        AIContextSettings settings = this.chat.getCompletionSettings();
        if (settings == null) {
            DBWorkbench.getPlatformUI().showError("Can't open editor", "Please set the active connection");
            return;
        }
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        DBPDataSourceContainer container = settings.getDataSourceContainer();
        IEditorPart activeEditor = page.getActiveEditor();
        if (AIChatView.activateEditor(consumer, activeEditor, container, page)) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart editor = reference.getEditor(false);
            if (AIChatView.activateEditor(consumer, editor, container, page)) {
                return;
            }
            ++n2;
        }
        SQLEditorUtils.openNewSqlConsoleAndTryConnect((DBPDataSourceContainer)container, editorOrNull -> {
            if (editorOrNull != null) {
                consumer.accept((SQLEditor)editorOrNull);
            }
        });
    }

    private static boolean activateEditor(@NotNull Consumer<SQLEditor> consumer, @Nullable IEditorPart editor, @Nullable DBPDataSourceContainer container, @NotNull IWorkbenchPage page) {
        SQLEditor sqlEditor;
        if (editor instanceof SQLEditor && (sqlEditor = (SQLEditor)editor).getDataSourceContainer() == container) {
            page.activate((IWorkbenchPart)editor);
            consumer.accept(sqlEditor);
            return true;
        }
        return false;
    }

    @Nullable
    private DBPDataSource getActiveDataSource() {
        AIContextSettings settings = this.chat.getCompletionSettings();
        if (settings == null || settings.getDataSourceContainer() == null) {
            return null;
        }
        return settings.getDataSourceContainer().getDataSource();
    }

    private class ViewController
    implements AIChatController {
        private ViewController() {
        }

        @Override
        public void executeInEditor(@NotNull String text) {
            AIChatView.this.findOrOpenEditor(editor -> UIUtils.asyncExec(() -> {
                Document document = new Document(text);
                SQLRuleManager ruleManager = editor.getRuleManager();
                SQLSyntaxManager syntaxManager = editor.getSyntaxManager();
                DBPDataSourceContainer container = editor.getDataSourceContainer();
                SQLParserContext parserContext = new SQLParserContext(container, syntaxManager, ruleManager, (IDocument)document);
                List scriptElements = SQLScriptParser.extractScriptQueries((SQLParserContext)parserContext, (int)0, (int)text.length(), (boolean)true, (boolean)false, (boolean)true);
                DBPDataSource dataSource = AIChatView.this.getActiveDataSource();
                if (dataSource == null) {
                    return;
                }
                if (!AIUtils.confirmExecutionIfNeeded((DBPDataSource)dataSource, (List)scriptElements, (boolean)false)) {
                    return;
                }
                try {
                    AIUtils.disableAutoCommitIfNeeded((DBRProgressMonitor)new VoidProgressMonitor(), (List)scriptElements, (DBCExecutionContext)AbstractDataSourceHandler.getExecutionContextFromPart((IWorkbenchPart)editor));
                }
                catch (DBException e) {
                    log.error((Object)"Error when trying to disable auto-commit:", (Throwable)e);
                    return;
                }
                boolean oldShowScriptRulerOnExecution = editor.getShowScriptRulerOnExecution();
                editor.setShowScriptRulerOnExecution(false);
                SQLQueryListener queryListener = new SQLQueryListener((SQLEditor)editor, oldShowScriptRulerOnExecution){
                    private final /* synthetic */ SQLEditor val$editor;
                    private final /* synthetic */ boolean val$oldShowScriptRulerOnExecution;
                    {
                        this.val$editor = sQLEditor;
                        this.val$oldShowScriptRulerOnExecution = bl;
                    }

                    public void onStartScript() {
                    }

                    public void onStartQuery(DBCSession session, SQLQuery query) {
                    }

                    public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
                    }

                    public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
                    }

                    public void onEndSqlJob(DBCSession session, SqlJobResult result) {
                        UIUtils.asyncExec(() -> this.val$editor.setShowScriptRulerOnExecution(this.val$oldShowScriptRulerOnExecution));
                    }
                };
                editor.processQueries(scriptElements, true, false, false, true, queryListener, null);
            }));
        }

        @Override
        public void openInEditor(@NotNull String text, @Nullable AIChatConversation conversation) {
            AIChatView.this.findOrOpenEditor(editor -> {
                ISelection selection = editor.getSelectionProvider().getSelection();
                IDocument document = editor.getDocument();
                if (document != null && selection instanceof TextSelection) {
                    TextSelection textSelection = (TextSelection)selection;
                    try {
                        int offset = textSelection.getOffset();
                        int length = textSelection.getLength();
                        SQLScriptElement query = editor.extractQueryAtPos(offset);
                        if (query != null) {
                            offset = query.getOffset();
                            length = query.getLength();
                        }
                        document.replace(offset, length, text);
                        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + text.length(), 0));
                        editor.showExtraPresentation(null);
                        if (conversation != null) {
                            IAnnotationModel annotationModel = Objects.requireNonNull(editor.getAnnotationModel());
                            annotationModel.addAnnotation((Annotation)new AIChatAnnotation(conversation.getId()), new Position(offset, text.length()));
                        }
                    }
                    catch (BadLocationException ex) {
                        DBWorkbench.getPlatformUI().showError("Insert SQL", "Error inserting SQL completion in text editor", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        @Nullable
        public DBCExecutionContext getExecutionContext() {
            IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof DBPContextProvider) {
                DBPContextProvider contextProvider = (DBPContextProvider)activeEditor;
                return contextProvider.getExecutionContext();
            }
            return null;
        }

        @Override
        @NotNull
        public IWorkbenchPartSite getSite() {
            return AIChatView.this.getSite();
        }
    }
}

