/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ChatCodeEditor
extends SQLEditorBase {
    private final DBCExecutionContext executionContext;
    private final String code;
    private boolean prevPassToParent = false;

    public ChatCodeEditor(@Nullable DBCExecutionContext executionContext, @NotNull String code) {
        this.executionContext = executionContext;
        this.code = code;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getAction("Preferences.ContextAction").setEnabled(false);
    }

    public boolean isFoldingEnabled() {
        return false;
    }

    void createCodeEditor(IWorkbenchPartSite partSite, Composite parent) throws DBException {
        super.setHasVerticalRuler(true);
        try {
            StringEditorInput editorInput = new StringEditorInput("SQL Code", (CharSequence)this.code, true, GeneralUtils.getDefaultFileEncoding());
            super.init((IEditorSite)new SubEditorSite(partSite), (IEditorInput)editorInput);
        }
        catch (PartInitException e) {
            throw new DBException("Error initializing SQL panel", (Throwable)e);
        }
        super.createPartControl(parent);
        StyledText text = this.getTextViewer().getTextWidget();
        if (text != null) {
            text.setAlwaysShowScrollBars(false);
            parent.setLayoutData((Object)ChatCodeEditor.createTextLayoutData(text, 8));
            this.handleVerticalScroll(parent, text);
        }
        super.reloadSyntaxRules();
    }

    private void handleVerticalScroll(Composite parent, StyledText text) {
        ScrollBar verticalBar = text.getVerticalBar();
        verticalBar.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int detail = e.detail;
            boolean passToParent = false;
            if (CommonUtils.isBitSet((int)detail, (int)0x1000007) || CommonUtils.isBitSet((int)detail, (int)0x1000001) || CommonUtils.isBitSet((int)detail, (int)0x1000005)) {
                passToParent = verticalBar.getSelection() <= verticalBar.getMinimum();
            } else if (CommonUtils.isBitSet((int)detail, (int)0x1000008) || CommonUtils.isBitSet((int)detail, (int)0x1000002) || CommonUtils.isBitSet((int)detail, (int)0x1000006)) {
                boolean bl = passToParent = verticalBar.getSelection() + scrollBar.getSize().y >= verticalBar.getMaximum();
            }
            if (passToParent && this.prevPassToParent) {
                ScrollBar scBar;
                ScrolledComposite toControl = null;
                Composite comp = parent;
                while (comp != null) {
                    if (comp instanceof ScrolledComposite) {
                        ScrolledComposite sc;
                        toControl = sc = (ScrolledComposite)comp;
                        break;
                    }
                    comp = comp.getParent();
                }
                if (toControl != null && (scBar = toControl.getVerticalBar()) != null) {
                    Point origin = toControl.getOrigin();
                    if (CommonUtils.isBitSet((int)detail, (int)0x1000007)) {
                        toControl.setOrigin(origin.x, scBar.getMinimum());
                    } else if (CommonUtils.isBitSet((int)detail, (int)0x1000001)) {
                        toControl.setOrigin(origin.x, origin.y - scBar.getIncrement());
                    } else if (CommonUtils.isBitSet((int)detail, (int)0x1000005)) {
                        toControl.setOrigin(origin.x, origin.y - scBar.getPageIncrement());
                    } else if (CommonUtils.isBitSet((int)detail, (int)0x1000008)) {
                        toControl.setOrigin(origin.x, scBar.getMaximum());
                    } else if (CommonUtils.isBitSet((int)detail, (int)0x1000002)) {
                        toControl.setOrigin(origin.x, origin.y + scBar.getIncrement());
                    } else if (CommonUtils.isBitSet((int)detail, (int)0x1000006)) {
                        toControl.setOrigin(origin.x, origin.y + scBar.getPageIncrement());
                    }
                }
            }
            this.prevPassToParent = passToParent;
        }));
    }

    @NotNull
    static GridData createTextLayoutData(@NotNull StyledText text, int maxLines) {
        GridData data = new GridData(4, 4, true, true);
        Point size = text.computeSize(-1, -1);
        data.widthHint = Math.min(size.x, 500);
        data.heightHint = Math.min(size.y, text.getLineHeight() * maxLines);
        return data;
    }
}

