/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import com.dbeaver.ui.ai.resultset.ExplainErrorAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIIcons;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;

public class ExplainWithAIQuickFixProcessor
implements IQuickAssistProcessor {
    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        MarkerAnnotation m;
        return annotation instanceof MarkerAnnotation && SQLEditorUtils.isProblemMarker((IMarker)(m = (MarkerAnnotation)annotation).getMarker());
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        SQLEditorSourceViewer viewer;
        ISourceViewer iSourceViewer = invocationContext.getSourceViewer();
        return iSourceViewer instanceof SQLEditorSourceViewer && (viewer = (SQLEditorSourceViewer)iSourceViewer).getSqlEditor() instanceof SQLEditor;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    public ICompletionProposal[] computeQuickAssistProposals(final IQuickAssistInvocationContext invocationContext) {
        IAnnotationModel model = invocationContext.getSourceViewer().getAnnotationModel();
        if (model == null || !(invocationContext.getSourceViewer() instanceof SQLEditorSourceViewer)) {
            return new ICompletionProposal[0];
        }
        ArrayList<1> proposals = new ArrayList<1>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            final Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation)) continue;
            final Position pos = model.getPosition(annotation);
            if (!this.isAtPosition(invocationContext.getOffset(), pos)) continue;
            proposals.add(new ICompletionProposal(){

                public void apply(IDocument document) {
                    SQLEditorSourceViewer sourceViewer;
                    SQLEditorBase sQLEditorBase;
                    ISourceViewer iSourceViewer = invocationContext.getSourceViewer();
                    if (iSourceViewer instanceof SQLEditorSourceViewer && (sQLEditorBase = (sourceViewer = (SQLEditorSourceViewer)iSourceViewer).getSqlEditor()) instanceof SQLEditor) {
                        SQLEditor editor = (SQLEditor)sQLEditorBase;
                        ExplainErrorAction.openAiExplainAndFixChat(editor, pos.getOffset(), annotation.getText());
                    }
                }

                public String getAdditionalProposalInfo() {
                    return AIUIAdvancedMessages.ai_explain_and_fix_description;
                }

                public IContextInformation getContextInformation() {
                    return null;
                }

                public String getDisplayString() {
                    return NLS.bind((String)AIUIAdvancedMessages.ai_explain_and_fix_proposal_title, (Object)annotation.getText());
                }

                public Image getImage() {
                    return DBeaverIcons.getImage((DBPImage)AIIcons.AI);
                }

                public Point getSelection(IDocument document) {
                    return new Point(invocationContext.getOffset(), invocationContext.getLength());
                }
            });
        }
        return (ICompletionProposal[])proposals.toArray(ICompletionProposal[]::new);
    }
}

