/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.gemini;

import com.dbeaver.model.ai.engine.gemini.GeminiCompletionEngine;
import com.dbeaver.model.ai.engine.gemini.GeminiProperties;
import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class GeminiConfigurator
implements AIIObjectPropertyConfigurator<AIEngineDescriptor, GeminiProperties> {
    private static final String API_KEY_URL = "https://makersuite.google.com/app/apikey";
    private String token = "";
    private volatile String model = "";
    private volatile String transcriptModel = "";
    private boolean logQuery = false;
    private Button logQueryCheck;
    private Text tokenText;
    private Text temperatureText;
    private Combo modelCombo;
    private Combo transcriptModelCombo;
    private String temperature = "0.0";
    private Button listModelsButton;

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite rootComposite = UIUtils.createComposite((Composite)parent, (int)3);
        rootComposite.setLayoutData((Object)new GridData(768));
        this.tokenText = UIUtils.createLabelText((Composite)rootComposite, (String)AIUIAdvancedMessages.gemini_preference_page_token, (String)"", (int)0x400800);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        this.tokenText.setLayoutData((Object)gridData);
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage(AIUIAdvancedMessages.gemini_preference_page_token_message);
        this.createURLInfoLink(rootComposite);
        rootComposite.setLayoutData((Object)new GridData(768));
        this.createModelCombo(rootComposite);
        this.temperatureText = UIUtils.createLabelText((Composite)rootComposite, (String)AIUIAdvancedMessages.gemini_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.setToolTipText(AIUIAdvancedMessages.gemini_preference_page_text_temperature_info);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
        this.temperatureText.setLayoutData((Object)gridData);
        this.createTranscribeModelCombo(rootComposite);
        this.logQueryCheck = UIUtils.createCheckbox((Composite)rootComposite, (String)AIUIAdvancedMessages.gemini_preference_page_text_debug, (String)AIUIAdvancedMessages.gemini_preference_page_text_debug_tip, (boolean)false, (int)3);
        this.logQueryCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean bl = this.logQuery = this.logQueryCheck.getSelection();
        }));
        UIUtils.syncExec(this::applySettings);
    }

    private void createModelCombo(@NotNull Composite parentComposite) {
        this.modelCombo = UIUtils.createLabelCombo((Composite)parentComposite, (String)AIUIAdvancedMessages.gemini_preference_page_model, (String)"", (int)2048);
        this.modelCombo.setLayoutData((Object)new GridData(768));
        this.modelCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.model = this.modelCombo.getText();
        }));
        this.listModelsButton = UIUtils.createPushButton((Composite)parentComposite, null, (String)AIUIAdvancedMessages.gemini_preference_page_load_model, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshModels()));
    }

    private void createTranscribeModelCombo(@NotNull Composite parentComposite) {
        this.transcriptModelCombo = UIUtils.createLabelCombo((Composite)parentComposite, (String)AIUIAdvancedMessages.gemini_preference_page_model_transcript, (String)"", (int)2048);
        this.transcriptModelCombo.setLayoutData((Object)new GridData(768));
        this.transcriptModelCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.transcriptModel = this.transcriptModelCombo.getText();
        }));
    }

    private void refreshModels() {
        new AbstractJob("Listing models"){

            protected IStatus run(DBRProgressMonitor monitor) {
                if (GeminiConfigurator.this.token == null || GeminiConfigurator.this.token.isEmpty()) {
                    DBWorkbench.getPlatformUI().showError("Error reading model list", "Please enter your token", (Throwable)new Exception("Token is empty"));
                    return Status.CANCEL_STATUS;
                }
                GeminiProperties properties = new GeminiProperties();
                properties.setToken(GeminiConfigurator.this.token);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (GeminiCompletionEngine gemini = new GeminiCompletionEngine(properties);){
                        String prevModel = GeminiConfigurator.this.model;
                        List models = gemini.getModels(monitor);
                        UIUtils.syncExec(() -> {
                            GeminiConfigurator.this.modelCombo.setItems((String[])models.stream().map(AIModel::name).sorted().toArray(String[]::new));
                            int i = 0;
                            while (i < models.size()) {
                                if (GeminiConfigurator.this.modelCombo.getItem(i).equals(prevModel)) {
                                    GeminiConfigurator.this.modelCombo.select(i);
                                }
                                ++i;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    DBWorkbench.getPlatformUI().showError("Error reading model list", "Failed to read Gemini model list", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void loadSettings(@NotNull GeminiProperties configuration) {
        this.token = CommonUtils.toString((Object)configuration.getToken(), (String)"");
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.model = CommonUtils.toString((Object)configuration.getModel(), (String)"");
        this.transcriptModel = CommonUtils.toString((Object)configuration.getTranscribeModel(), (String)"");
        this.applySettings();
    }

    public void saveSettings(@NotNull GeminiProperties configuration) {
        configuration.setToken(this.token);
        configuration.setTemperature(CommonUtils.toDouble((Object)this.temperature, (double)0.0));
        configuration.setLoggingEnabled(this.logQuery);
        configuration.setModel(this.model);
        configuration.setTranscribeModel(this.transcriptModel);
    }

    public void resetSettings(@NotNull GeminiProperties geminiPropertiesLegacyAISettings) {
    }

    protected void applySettings() {
        if (this.token != null) {
            this.tokenText.setText(this.token);
        }
        if (this.temperature != null) {
            this.temperatureText.setText(this.temperature);
        }
        if (this.listModelsButton.isEnabled()) {
            this.modelCombo.setItems(new String[]{this.model});
            this.modelCombo.select(0);
        }
        if (CommonUtils.isEmpty((String)this.transcriptModel)) {
            this.transcriptModelCombo.setItems(new String[]{"models/gemini-2.5-flash"});
            this.transcriptModelCombo.select(0);
            this.transcriptModel = this.transcriptModelCombo.getText();
        }
        this.logQueryCheck.setSelection(this.logQuery);
    }

    public boolean isComplete() {
        return !this.tokenText.getText().isEmpty() && !this.modelCombo.getText().isEmpty();
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIAdvancedMessages.gemini_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> UIUtils.openWebBrowser((String)this.getApiKeyURL())));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        link.setLayoutData((Object)gd);
    }

    public Optional<AIEngineProperties> getCurrentProperties() {
        GeminiProperties properties = new GeminiProperties();
        this.saveSettings(properties);
        return Optional.of(properties);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }
}

