/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionDialog;
import org.jkiss.utils.CommonUtils;

public class AIFunctionCreateNewConnection
implements AIFunction {
    public static final String PARAM_DRIVER = "driver";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_DATABASE = "database";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String driverName = JSONUtils.getString(parameters, (String)PARAM_DRIVER);
        if (CommonUtils.isEmpty((String)driverName)) {
            throw new DBException("Driver parameter is missing");
        }
        String host = JSONUtils.getString(parameters, (String)PARAM_HOST);
        String port = JSONUtils.getString(parameters, (String)PARAM_PORT);
        String database = JSONUtils.getString(parameters, (String)PARAM_DATABASE);
        DBPConnectionConfiguration config = new DBPConnectionConfiguration();
        config.setHostName(host);
        config.setHostPort(port);
        config.setDatabaseName(database);
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        DBPDriver driver = registry.findDriver(driverName);
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> {
                boolean bl = NewConnectionDialog.openNewConnectionDialog((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (DBPDriver)driver, (DBPConnectionConfiguration)config);
            });
            return null;
        };
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Create new connection for " + driverName + " driver", callback);
    }
}

