/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.resultset;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatSession;
import com.dbeaver.model.ai.prompt.AIPromptFixSqlError;
import com.dbeaver.ui.ai.chat.AIChatView;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetErrorAction;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.StringUtils;

public final class ExplainErrorAction
implements IResultSetErrorAction {
    public void perform(@NotNull IResultSetContainer container, @NotNull IStatus status) {
        DBCExecutionContext context = container.getExecutionContext();
        if (context == null) {
            DBWorkbench.getPlatformUI().showError("AI Assistant", "Can't determine active execution context");
            return;
        }
        SQLEditor.QueryResultsContainer queryContainer = (SQLEditor.QueryResultsContainer)container;
        SQLScriptElement query = queryContainer.getQuery();
        SQLEditor editor = this.getSqlEditor(context);
        DBPDataSourceContainer dbpDataSourceContainer = queryContainer.getDataSourceContainer();
        String errorToFixMessage = CommonUtils.getAllExceptionMessages((Throwable)status.getException());
        AIProFeatures.AI_ERROR_FIX.use(dbpDataSourceContainer == null ? Collections.emptyMap() : AIProFeatures.buildFeatureParameters(dbpDataSourceContainer, Map.of("errorCode", status.getCode())));
        ExplainErrorAction.openAiExplainAndFixChat(editor, query, dbpDataSourceContainer, errorToFixMessage);
    }

    public static void openAiExplainAndFixChat(@NotNull SQLEditor editor, int queryOffset, @NotNull String errorToFixMessage) {
        SQLScriptElement query = editor.extractQueryAtPos(queryOffset);
        DBPDataSourceContainer container = editor.getDataSourceContainer();
        AIProFeatures.AI_ERROR_FIX.use(container == null ? Collections.emptyMap() : AIProFeatures.buildFeatureParameters(container));
        ExplainErrorAction.openAiExplainAndFixChat(editor, query, container, errorToFixMessage);
    }

    public static void openAiExplainAndFixChat(@Nullable SQLEditor editor, @NotNull SQLScriptElement query, @Nullable DBPDataSourceContainer dataSourceContainer, @NotNull String errorToFixMessage) {
        if (AISettingsManager.getInstance().getSettings().isAiDisabled()) {
            return;
        }
        try {
            AIChatControl chat = AIChatView.show().getChat();
            AIChatConversation conversation = new AIChatConversation("Fix error '" + StringUtils.truncateToSpace((String)errorToFixMessage, (int)40) + "'", (AIPromptGenerator)AIPromptFixSqlError.create(() -> dataSourceContainer == null ? null : new DBSLogicalDataSource(dataSourceContainer)), List.of(), dataSourceContainer);
            if (editor != null) {
                conversation = chat.findOrCreateAssociatedConversation(editor, query, conversation);
            }
            AIChatSession chatSession = chat.getChatSession();
            AIChatConversationSettings customSettings = new AIChatConversationSettings(chatSession, conversation);
            customSettings.loadDataSourceDefaults();
            conversation.setCustomSettings(customSettings);
            chat.selectConversation(conversation);
            chat.setCompletionSettings((AIContextSettings)customSettings);
            AIMessage message = AIPromptFixSqlError.createErrorExplainMessage((String)errorToFixMessage, (String)query.getText());
            chat.submitPrompt(message);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("AI Assistant", "Can't open AI chat", (Throwable)e);
        }
    }

    public boolean isVisible(@NotNull IResultSetContainer container, @NotNull IStatus status) {
        return container instanceof SQLQueryContainer && !AISettingsManager.getInstance().getSettings().isAiDisabled();
    }

    @Nullable
    private SQLEditor getSqlEditor(@NotNull DBCExecutionContext context) {
        IEditorReference[] editorReferences;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SQLEditor sqlEditor;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof SQLEditor && this.isEditorContextMatching(sqlEditor = (SQLEditor)editor, context)) {
                return sqlEditor;
            }
            ++n2;
        }
        return null;
    }

    private boolean isEditorContextMatching(SQLEditor sqlEditor, DBCExecutionContext context) {
        DBCExecutionContext editorCtx = sqlEditor.getExecutionContext();
        return editorCtx != null && (editorCtx == context || editorCtx.getContextId() == context.getContextId());
    }
}

