/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.connections.k8s;

import com.dbeaver.ui.internal.UICoreMessages;
import java.io.IOException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageKubernetes
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final Log log = Log.getLog(PrefPageKubernetes.class);
    public static final String PAGE_ID = "com.dbeaver.ee.runtime.ui.preferencePages.page.k8s";
    private TextWithOpen kubectlCliExecutablePath;

    public PrefPageKubernetes() {
        this.setTitle("k8s preferences");
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Group cliGroup = UIUtils.createControlGroup((Composite)parent, (String)"kubectl settings", (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)cliGroup, (String)"Path to kubectl");
        Object execName = "kubectl";
        if (RuntimeUtils.isWindows()) {
            execName = (String)execName + ".exe";
        }
        this.kubectlCliExecutablePath = new TextWithOpenFile((Composite)cliGroup, "Path to kubectl", new String[]{execName, "*"}, true, false);
        this.kubectlCliExecutablePath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.kubectlCliExecutablePath.setText(CommonUtils.notEmpty((String)ModelPreferences.getPreferences().getString("kubectlPath")));
        UIUtils.createInfoLabel((Composite)cliGroup, (String)UICoreMessages.pref_page_kubectl_path_tip, (int)768, (int)2);
        return cliGroup;
    }

    protected void performDefaults() {
        this.kubectlCliExecutablePath.setText("");
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        store.setValue("kubectlPath", this.kubectlCliExecutablePath.getText());
        try {
            store.save();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return true;
    }
}

